// mlsegclock.h
//
//   A Segment Clock widget.
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//    $Id: mlsegclock.h,v 1.2 2007/09/04 11:35:14 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU Library General Public License 
//   version 2 as published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef MLSEGCLOCK_H
#define MLSEGCLOCK_H

#include <qwidget.h>
#include <qdatetime.h>
#include <qtimer.h>

#include <mlseglist.h>

//
// Fonts
//
#define MLSEGCLOCK_TITLE_FONT_FACE "Helvetica"
#define MLSEGCLOCK_TITLE_FONT_SIZE 24
#define MLSEGCLOCK_TITLE_FONT_WEIGHT QFont::Normal

#define MLSEGCLOCK_DIGIT_FONT_FACE "Helvetica"
#define MLSEGCLOCK_DIGIT_FONT_SIZE 36
#define MLSEGCLOCK_DIGIT_FONT_WEIGHT QFont::Normal

#define MLSEGCLOCK_LABEL_FONT_FACE "System"
#define MLSEGCLOCK_LABEL_FONT_SIZE 16
#define MLSEGCLOCK_LABEL_FONT_WEIGHT QFont::Normal


/**
 * @short Displays a broadcast segment clock and countdown timer.
 * @author Fred Gleason <fredg@wava.com>
 *
 * This class implements a widget to display wall clock time and a countdown
 * timer.  The countdown timer operates on segment data supplied in a 
 * @ref MLSegList object.  Each time segment can have a text label associated
 * with it, which is displayed at the bottom of the widget.
 * @see MLSegList
 **/

class MLSegClock : public QWidget
{
  Q_OBJECT
  public:
  enum Orientation {Horizontal=0,Vertical=1};

  /**
   * Instantiates the widget.
   * @param layout Indicates layout style of the widget.  SEG_HORIZ gives
   * a horizontal layout (clock and timer side-by-side), and SEG_VERT give
   * a vertical layout (the clock stacked above the timer).
   **/
    MLSegClock(Qt::Orientation layout,QWidget *parent=0,
	      const char *name=0);
    QSizePolicy sizePolicy() const;
    QSize sizeHint() const;

  /**
   * Indicate whether the hour digits in the clock should be displayed.
   **/
    bool showHour() const;

  /**
   * Set whether the hour digits in the clock should be displayed.
   **/
    void setShowHour(bool state);

  /**
   * Load a segment list.  
   **/     
    void loadSegList(struct MLSegList *list);

  /**
   * Set the time display to be in twelve hour mode.
   **/
    void set12Hour();

  /**
   * Set the time display to be in twenty-four hour (military) style.
   **/
    void set24Hour();

  /**
   * Set the time offset.
   * @param secs Time offset in seconds.
   **/
    void setOffset(int secs);

  private slots:
    void tickClock();

  signals:
  /**
   * Indicates that the indexed segment entry has started counting down.
   **/
    void segStarted(int);
  /**
   * Indicates that the indexed segment entry has finished counting down.
   **/
    void segFinished(int);

  protected:
    void paintEvent(QPaintEvent *);

  private:
    int clock_x,clock_y;
    int clock_size_x;
    int clock_size_y; 
    int segment_x,segment_y;
    int segment_size_x;
    int segment_size_y; 
    int label_x,label_y;
    QTime current_time,previous_time;
    MLSegList *rseglist;
    int current_index;
    int time_style;
    int time_offset;
    QFont title_font;
    QFont digit_font;
    QFont label_font;
    bool seg_show_hour;
    Qt::Orientation seg_style;
};

#endif  // MLSEGCLOCK_H
