// standard_Age_report.cpp
//
// Paint a page of the Standard Age Report.
//
//   (C) Copyright 2002-2005 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qpainter.h>
#include <qsqldatabase.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qprinter.h>

#include <print_report.h>
#include <globals.h>

int total_callers[3];


bool PrintReport::StandardAgeReport(vector<QPixmap *> *pages)
{
  QString str;

  pages->push_back(new QPixmap(PREVIEW_X_SIZE,PREVIEW_Y_SIZE));
  QPainter *p=new QPainter();
  if(!p->begin(pages->back())) {
    delete p;
    return false;
  }
  paintStandardAgeReport(p);
  p->end();
  delete p;
  return true;
}


bool PrintReport::StandardAgeReport(QPrinter *ptr)
{
  QPainter *p=new QPainter();
  if(!p->begin(ptr)) {
    delete p;
    return false;
  }
  paintStandardAgeReport(p);
  p->end();
  delete p;
  return true;
}


void PrintReport::paintStandardAgeReport(QPainter *p)
{
  QString str;

  p->fillRect(0,0,p->window().width(),p->window().height(),white);

  //
  // Generate Totals
  //
  SARGetCallers(total_callers,0,120);

  //
  // Display Header
  //
  p->setPen(black);
  p->setBrush(black);
  p->setFont(QFont("helvetica",16,QFont::Bold));
  p->drawText((p->window().width()-p->fontMetrics().width(print_header[0]))/2,
	      (int)(p->window().height()*.1263),print_header[0]);
  p->setFont(QFont("helvetica",14,QFont::Normal));
  p->drawText((p->window().width()-p->fontMetrics().width(print_header[1]))/2,
	      (int)(p->window().height()*.1515),print_header[1]);
  str=QString().sprintf("Screened Calls from %s to %s",
			(const char *)start_datetime.toString("MM/dd/yyyy"),
			(const char *)end_datetime.toString("MM/dd/yyyy"));
  p->setFont(QFont("helvetica",12,QFont::Normal));
  p->drawText((p->window().width()-p->fontMetrics().width(str))/2,(int)(p->window().height()*.1894),str);

  p->setFont(QFont("helvetica",12,QFont::Bold));
  p->drawText(p->window().width()/8,(int)(p->window().height()*.2525),"Age Group");
  p->drawText(4*p->window().width()/8,(int)(p->window().height()*.2525)," Males");
  p->drawText(5*p->window().width()/8,(int)(p->window().height()*.2525),"Females");
  p->drawText(6*p->window().width()/8,(int)(p->window().height()*.2525),"   All");
  
  p->setFont(QFont("helvetica",12,QFont::Normal));
  SARWriteLine(p,12,17,p->window().width(),p->window().height(),(int)(p->window().height()*.303),total_callers[2]);
  SARWriteLine(p,18,24,p->window().width(),p->window().height(),(int)(p->window().height()*.3662),total_callers[2]);
  SARWriteLine(p,25,34,p->window().width(),p->window().height(),(int)(p->window().height()*.4293),total_callers[2]);
  SARWriteLine(p,35,44,p->window().width(),p->window().height(),(int)(p->window().height()*.4924),total_callers[2]);
  SARWriteLine(p,45,49,p->window().width(),p->window().height(),(int)(p->window().height()*.5555),total_callers[2]);
  SARWriteLine(p,50,54,p->window().width(),p->window().height(),(int)(p->window().height()*.6187),total_callers[2]);
  SARWriteLine(p,55,64,p->window().width(),p->window().height(),(int)(p->window().height()*.6818),total_callers[2]);
  SARWriteLine(p,65,-1,p->window().width(),p->window().height(),(int)(p->window().height()*.7449),total_callers[2]);
  p->setFont(QFont("helvetica",12,QFont::Bold));
  SARWriteLine(p,-1,-1,p->window().width(),p->window().height(),(int)(p->window().height()*.808),total_callers[2]);

  p->setFont(QFont("helvetica",6,QFont::Light));
  p->drawText((int)(p->window().width()/8.5),(int)(p->window().height()*.9090),
	      "Generated by CallCommander");
  p->drawText(p->window().width()-p->fontMetrics().width(WEB_URL)-(int)(p->window().width()/8.5),
	      (int)(p->window().height()*.9090),WEB_URL);
}


void PrintReport::SARWriteLine(QPainter *p,int start_age,int end_age,
			       int width,int height,int ypos,int total)
{
  int callers[3];
  QString str;

  if(start_age<0) {
    SARGetCallers(callers,0,120);
    p->drawText(width/8,ypos,"Total");
  }
  else {
    if(end_age<0) {
      SARGetCallers(callers,start_age,120);
      p->drawText(width/8,ypos,QString().
		  sprintf("Ages %d+",start_age));
    }
    else {
      SARGetCallers(callers,start_age,end_age);
      p->drawText(width/8,ypos,QString().
		  sprintf("Ages %d - %d",start_age,end_age));
    }
  }
  if(total==0) {
    str=QString().sprintf("0.0%");
    p->drawText(45*width/80-p->fontMetrics().width(str),ypos,str);
    str=QString().sprintf("[0]");
    p->drawText(45*width/80-p->fontMetrics().width(str),ypos+height/45,str);
    
    str=QString().sprintf("0.0%");
    p->drawText(55*width/80-p->fontMetrics().width(str),ypos,str);
    str=QString().sprintf("[0]");
    p->drawText(55*width/80-p->fontMetrics().width(str),ypos+height/45,str);
    
    str=QString().sprintf("0.0%");
    p->drawText(65*width/80-p->fontMetrics().width(str),ypos,str);
    str=QString().sprintf("[0]");
    p->drawText(65*width/80-p->fontMetrics().width(str),ypos+height/45,str);
  }
  else {
    str=QString().sprintf("%5.1f%%",100.0*((float)callers[0]/(float)total));
    p->drawText(45*width/80-p->fontMetrics().width(str),ypos,str);
    str=QString().sprintf("[%d]",callers[0]);
    p->drawText(45*width/80-p->fontMetrics().width(str),ypos+height/45,str);
    
    str=QString().sprintf("%5.1f%%",100.0*((float)callers[1]/(float)total));
    p->drawText(55*width/80-p->fontMetrics().width(str),ypos,str);
    str=QString().sprintf("[%d]",callers[1]);
    p->drawText(55*width/80-p->fontMetrics().width(str),ypos+height/45,str);
    
    str=QString().sprintf("%5.1f%%",100.0*((float)callers[2]/(float)total));
    p->drawText(65*width/80-p->fontMetrics().width(str),ypos,str);
    str=QString().sprintf("[%d]",callers[2]);
    p->drawText(65*width/80-p->fontMetrics().width(str),ypos+height/45,str);
  }
}


void PrintReport::SARGetCallers(int callers[3],int start_age,int end_age)
{
  QString sql;
  QSqlQuery *q;

  sql=QString().sprintf("select ID from DETAILS_%s where %s&&(GENDER=\"M\")\
                         &&(AGE>=%d)&&(AGE<=%d)",
			(const char *)print_showcode,
			(const char *)print_filter,start_age,end_age);
  q=new QSqlQuery(sql);
  callers[0]=q->size();
  delete q;

  sql=QString().sprintf("select ID from DETAILS_%s where %s&&(GENDER=\"F\")\
                         &&(AGE>=%d)&&(AGE<=%d)",
			(const char *)print_showcode,
			(const char *)print_filter,start_age,end_age);
  q=new QSqlQuery(sql);
  callers[1]=q->size();
  delete q;
  callers[2]=callers[0]+callers[1];
}
