// drawcaps.cpp
//
// A Qt-based application for controlling broadcast telephone interfaces.
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qpainter.h>
#include <qpixmap.h>

#include <globals.h>
#include <mithlond.h>


void MainWidget::DrawCaps()
{
  QPainter *p=new QPainter();
  QPointArray triangle=QPointArray(3);
  QFont font;

  //
  // Draw the Icons
  //
  // Line Idle/Unavailable
  //
  telos_icon_modulo[0]=1;
  telos_icon_frame[0]=0;
  telos_icon[0][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[0][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(24,24,3,3,QColor(color1));
  p->end();

  //
  // Line On Main
  //
  telos_icon_modulo[1]=1;
  telos_icon_frame[1]=0;
  telos_icon[1][0]=QPixmap(50,50,1);
  triangle.setPoint(0,20,5);
  triangle.setPoint(1,0,25);
  triangle.setPoint(2,20,45);
  p->begin(&telos_icon[1][0]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(20,15,20,20,QColor(color1));
  p->drawPolygon(triangle);
  p->end();

  //
  // Line On Conf
  //
  telos_icon_modulo[2]=1;
  telos_icon_frame[2]=0;
  telos_icon[2][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[2][0]);
  triangle.setPoint(0,20,5);
  triangle.setPoint(1,40,25);
  triangle.setPoint(2,20,45);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(0,15,20,20,QColor(color1));
  p->drawPolygon(triangle);
  p->end();

  //
  // Line Locked
  //
  telos_icon_modulo[3]=1;
  telos_icon_frame[3]=0;
  telos_icon[3][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[3][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(10,25,25,20,QColor(color1));
  p->drawArc(15,10,15,15,0,2880);
  p->moveTo(15,18);
  p->lineTo(15,25);
  p->moveTo(29,18);
  p->lineTo(29,25);
  p->end();

  //
  // Line Off Hook
  //
  telos_icon_modulo[4]=1;
  telos_icon_frame[4]=0;
  telos_icon[4][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[4][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(24,24,3,3,QColor(color1));
  p->fillRect(18,18,3,3,QColor(color1));
  p->fillRect(18,30,3,3,QColor(color1));
  p->fillRect(30,18,3,3,QColor(color1));
  p->fillRect(30,30,3,3,QColor(color1));
  p->end();

  //
  // Line On Hold
  //
  telos_icon_modulo[5]=3;
  telos_icon_frame[5]=0;

  telos_icon[5][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[5][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(15,15,20,20,QColor(color1));
  p->moveTo(20,10);
  p->lineTo(10,10);
  p->lineTo(10,40);
  p->lineTo(20,40);
  p->moveTo(30,10);
  p->lineTo(40,10);
  p->lineTo(40,40);
  p->lineTo(30,40);
  p->end();

  telos_icon[5][1]=QPixmap(50,50,1);
  p->begin(&telos_icon[5][1]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(15,15,20,20,QColor(color1));
  p->moveTo(20,10);
  p->lineTo(10,10);
  p->lineTo(10,40);
  p->lineTo(20,40);
  p->moveTo(30,10);
  p->lineTo(40,10);
  p->lineTo(40,40);
  p->lineTo(30,40);
  p->end();

  telos_icon[5][2]=QPixmap(50,50,1);
  p->begin(&telos_icon[5][2]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(15,15,20,20,QColor(color1));
  p->end();

  //
  // Line On Screened Hold
  //
  telos_icon_modulo[6]=1;
  telos_icon_frame[6]=0;
  telos_icon[6][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[6][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->moveTo(10,25);
  p->lineTo(20,39);
  p->lineTo(20,38);
  p->lineTo(10,24);
  p->lineTo(10,26);
  p->lineTo(20,40);
  p->lineTo(39,10);
  p->lineTo(39,9);
  p->lineTo(20,39);
  p->lineTo(20,41);
  p->lineTo(39,11);
  p->end();

  //
  // Line Ready/Next
  //
  telos_icon_modulo[7]=3;
  telos_icon_frame[7]=0;

  telos_icon[7][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[7][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->moveTo(10,25);
  p->lineTo(20,39);
  p->lineTo(20,38);
  p->lineTo(10,24);
  p->lineTo(10,26);
  p->lineTo(20,40);
  p->lineTo(39,10);
  p->lineTo(39,9);
  p->lineTo(20,39);
  p->lineTo(20,41);
  p->lineTo(39,11);
  p->end();

  telos_icon[7][1]=QPixmap(50,50,1);
  p->begin(&telos_icon[7][1]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->moveTo(10,25);
  p->lineTo(20,39);
  p->lineTo(20,38);
  p->lineTo(10,24);
  p->lineTo(10,26);
  p->lineTo(20,40);
  p->lineTo(39,10);
  p->lineTo(39,9);
  p->lineTo(20,39);
  p->lineTo(20,41);
  p->lineTo(39,11);
  p->end();

  telos_icon[7][2]=QPixmap(50,50,1);
  p->begin(&telos_icon[7][2]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->end();

  //
  // Line Ringing
  //
  telos_icon_modulo[8]=3;
  telos_icon_frame[8]=0;

  telos_icon[8][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[8][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->drawRect(14,14,22,22);
  p->drawRect(15,15,20,20);
  p->drawRect(16,16,18,18);
  p->end();

  telos_icon[8][1]=QPixmap(50,50,1);
  p->begin(&telos_icon[8][1]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(15,15,20,20,QColor(color1));
  p->end();

  telos_icon[8][2]=QPixmap(50,50,1);
  p->begin(&telos_icon[8][2]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->drawRect(14,14,22,22);
  p->drawRect(15,15,20,20);
  p->drawRect(16,16,18,18);
  p->drawRect(17,17,16,16);
  p->drawRect(18,18,14,14);
  p->drawRect(19,19,12,12);
  p->end();

  //
  // Line Busied Out
  //
  telos_icon_modulo[9]=1;
  telos_icon_frame[9]=0;
  telos_icon[9][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[9][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->moveTo(10,10);
  p->lineTo(39,39);
  p->lineTo(39,38);
  p->lineTo(10,9);
  p->lineTo(10,11);
  p->lineTo(39,40);
  p->moveTo(10,39);
  p->lineTo(39,10);
  p->lineTo(39,9);
  p->lineTo(10,38);
  p->lineTo(10,40);
  p->lineTo(39,11);
  p->end();

  //
  // Line Unavailable
  //
  telos_icon_modulo[10]=1;
  telos_icon_frame[10]=0;
  telos_icon[10][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[10][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->end();

  //
  // Line on Handset
  //
  telos_icon_modulo[11]=1;
  telos_icon_frame[11]=0;
  telos_icon[11][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[11][0]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->translate(25,25);
  p->drawPie(-20,-20,40,40,0,2881);
  p->fillRect(-20,5,40,3,QColor(color1));
  p->setPen(QColor(color0));
  p->setBrush(QColor(color0));
  p->drawPie(-5,-5,10,10,0,2881);
  p->fillRect(-25,-25,50,11,QColor(color0));
  p->end();

  //
  // Line on Speakerphone
  //
  telos_icon_modulo[12]=1;
  telos_icon_frame[12]=0;
  telos_icon[12][0]=QPixmap(50,50,1);
  p->begin(&telos_icon[12][0]);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,50,50);
  p->fillRect(10,15,10,15,QColor(color1));
  p->moveTo(20,15);
  p->lineTo(30,5);
  p->moveTo(20,16);
  p->lineTo(30,6);
  p->moveTo(20,17);
  p->lineTo(30,7);
  p->moveTo(30,40);
  p->lineTo(20,30);
  p->moveTo(30,39);
  p->lineTo(20,29);
  p->moveTo(30,38);
  p->lineTo(20,28);
  p->moveTo(30,5);
  p->lineTo(30,40);
  p->moveTo(29,6);
  p->lineTo(29,39);
  p->moveTo(28,7);
  p->lineTo(28,38);
  p->fillRect(40,5,2,5,QColor(color1));
  p->fillRect(40,20,2,5,QColor(color1));
  p->fillRect(40,35,2,5,QColor(color1));
  p->end();


  //
  // Draw Button Caps
  //
  for(int i=0;i<12;i++) {
    for(int j=0;j<13;j++) {
      for(int k=0;k<3;k++) {
	if(k<telos_icon_modulo[j]) {
	  telos_cap[i][j][k]=QPixmap(80,80,1);
	  p->begin(&telos_cap[i][j][k]);
	  p->setPen(QColor(color1));
	  font=QFont("Helvetica",ml_config->lineFontSize(i),QFont::Bold);
	  font.setPixelSize(ml_config->lineFontSize(i));
	  p->setFont(font);
	  p->eraseRect(0,0,79,79);
	  p->drawPixmap(30,0,telos_icon[j][k]);
	  p->drawText(10,70,ml_config->lineLabel(i));
	  p->end();
	}
      }
    }
  }

  //
  // Screen Button
  //
  telos_screen_icon=QPixmap(80,80,1);
  p->begin(&telos_screen_icon);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->moveTo(25,44);
  p->lineTo(35,54);
  p->lineTo(55,24);
  p->moveTo(25,45);
  p->lineTo(35,55);
  p->lineTo(55,25);
  p->moveTo(25,46);
  p->lineTo(35,56);
  p->lineTo(55,26);
  p->moveTo(30,15);
  p->lineTo(15,15);
  p->lineTo(15,65);
  p->lineTo(30,65);
  p->moveTo(50,15);
  p->lineTo(65,15);
  p->lineTo(65,65);
  p->lineTo(50,65);
  p->end();

  //
  // Hold Button
  //
  telos_hold_icon=QPixmap(80,80,1);
  p->begin(&telos_hold_icon);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->fillRect(25,25,30,30,QColor(color1));
  p->moveTo(30,15);
  p->lineTo(15,15);
  p->lineTo(15,65);
  p->lineTo(30,65);
  p->moveTo(50,15);
  p->lineTo(65,15);
  p->lineTo(65,65);
  p->lineTo(50,65);
  p->end();

  //
  // Drop Button
  //
  telos_drop_icon=QPixmap(80,80,1);
  p->begin(&telos_drop_icon);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawRect(15,15,50,50);
  p->fillRect(38,38,4,4,QColor(color1));
  p->end();

  //
  // Busy Button
  //
  telos_busy_icon=QPixmap(80,80,1);
  p->begin(&telos_busy_icon);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->moveTo(20,19);
  p->lineTo(59,58);
  p->moveTo(20,20);
  p->lineTo(59,59);
  p->moveTo(20,21);
  p->lineTo(59,60);
  p->moveTo(59,19);
  p->lineTo(20,58);
  p->moveTo(59,20);
  p->lineTo(20,59);
  p->moveTo(59,21);
  p->lineTo(20,60);
  p->end();

  //
  // Dump Button
  //
  telos_dump_icon=QPixmap(80,80,1);
  p->begin(&telos_dump_icon);
  p->setPen(QColor(color1));
  p->eraseRect(0,0,79,79);
  font=QFont("Helvetica",22,QFont::Bold);
  font.setPixelSize(22);
  p->setFont(font);
  p->drawText(9,47,"?#@!");
  p->end();

  //
  // Record Button
  //
  telos_record_modulo=8;

  telos_record_icon[7]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[7]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  telos_record_icon[6]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[6]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(15);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-15);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(15);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  telos_record_icon[5]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[5]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(30);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-30);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(30);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  telos_record_icon[4]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[4]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(45);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-45);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(45);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);

  p->end();

  telos_record_icon[3]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[3]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(60);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-60);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(60);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  telos_record_icon[2]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[2]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(75);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-75);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(75);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  telos_record_icon[1]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[1]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(90);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-90);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(90);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  telos_record_icon[0]=QPixmap(80,80,1);
  p->begin(&telos_record_icon[0]);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->drawArc(7,25,30,30,0,5760);
  p->drawPie(19,37,6,6,0,5760);
  p->translate(22,40);
  p->rotate(105);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->rotate(-105);

  p->translate(-22,-40);
  p->drawArc(41,25,30,30,0,5760);
  p->drawPie(53,37,6,6,0,5760);
  p->translate(56,40);
  p->rotate(105);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->fillRect(-2,-12,4,7,QColor(color1));
  p->rotate(120);
  p->translate(-56,-40);
  p->end();

  //
  // Next Button
  //
  telos_next_icon=QPixmap(80,80,1);
  p->begin(&telos_next_icon);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  triangle.setPoint(0,20,20);
  triangle.setPoint(1,40,40);
  triangle.setPoint(2,20,60);
  p->drawPolygon(triangle);
  triangle.setPoint(0,37,20);
  triangle.setPoint(1,57,40);
  triangle.setPoint(2,37,60);
  p->drawPolygon(triangle);
  p->fillRect(54,20,7,40,QColor(color1));
  p->end();

  //
  // Keypad Button
  //
  telos_keypad_icon=QPixmap(80,80,1);
  p->begin(&telos_keypad_icon);
  p->setPen(QColor(color1));
  p->setBrush(QColor(color1));
  p->eraseRect(0,0,79,79);
  p->fillRect(20,12,12,12,QColor(color1));
  p->fillRect(34,12,12,12,QColor(color1));
  p->fillRect(48,12,12,12,QColor(color1));
  p->fillRect(20,26,12,12,QColor(color1));
  p->fillRect(34,26,12,12,QColor(color1));
  p->fillRect(48,26,12,12,QColor(color1));
  p->fillRect(20,40,12,12,QColor(color1));
  p->fillRect(34,40,12,12,QColor(color1));
  p->fillRect(48,40,12,12,QColor(color1));
  p->fillRect(34,54,12,12,QColor(color1));
  p->end();

  //
  // Cell Call Icons
  //
  telos_caller_cell_icon[0]=QPixmap(25,25);
  p->begin(&telos_caller_cell_icon[0]);
  p->setPen(QColor(black));
  p->setBrush(QColor(black));
  p->eraseRect(0,0,25,25);
  p->end();

  telos_caller_cell_icon[1]=QPixmap(25,25);
  p->begin(&telos_caller_cell_icon[1]);
  p->setPen(QColor(black));
  p->setBrush(QColor(black));
  p->eraseRect(0,0,25,25);
  p->translate(12,12);
  p->drawPie(-2,-2,4,4,0,5760);
  p->moveTo(0,0);
  p->lineTo(0,10);
  p->setPen(QColor(red));
  p->drawArc(-5,-5,10,10,-720,1440);
  p->drawArc(-8,-8,16,16,-720,1440);
  p->drawArc(-11,-11,22,22,-720,1440);
  p->drawArc(-5,-5,10,10,2160,1440);
  p->drawArc(-8,-8,16,16,2160,1440);
  p->drawArc(-11,-11,22,22,2160,1440);
  p->end();

  //
  // Call Quality Icons
  //
  telos_caller_quality_icon[0]=QPixmap(25,25);
  p->begin(&telos_caller_quality_icon[0]);
  p->setPen(QColor(black));
  p->setBrush(QColor(black));
  p->eraseRect(0,0,25,25);
  p->end();

  telos_caller_quality_icon[1]=QPixmap(25,25);
  p->begin(&telos_caller_quality_icon[1]);
  p->setPen(QColor(red));
  p->setBrush(QColor(red));
  p->eraseRect(0,0,25,25);
  p->translate(12,12);
  p->drawPie(-5,-5,10,10,0,5760);
  p->moveTo(-5,-5);
  p->lineTo(-9,-9);
  p->moveTo(-5,5);
  p->lineTo(-9,9);
  p->moveTo(5,5);
  p->lineTo(9,9);
  p->moveTo(5,-5);
  p->lineTo(9,-9);
  p->moveTo(-7,0);
  p->lineTo(-12,0);
  p->moveTo(7,0);
  p->lineTo(12,0);
  p->moveTo(0,-7);
  p->lineTo(0,-12);
  p->moveTo(0,7);
  p->lineTo(0,12);
  p->end();

  telos_caller_quality_icon[2]=QPixmap(25,25);
  p->begin(&telos_caller_quality_icon[2]);
  p->setPen(QColor(red));
  p->setBrush(QColor(red));
  p->eraseRect(0,0,25,25);
  p->translate(12,12);
  p->drawPie(-5,-5,10,10,0,5760);
  p->end();

  telos_caller_quality_icon[3]=QPixmap(25,25);
  p->begin(&telos_caller_quality_icon[3]);
  p->setPen(QColor(darkYellow));
  p->setBrush(QColor(darkYellow));
  p->eraseRect(0,0,25,25);
  p->translate(12,12);
  p->drawPie(-5,-5,10,10,0,5760);
  p->end();

  telos_caller_quality_icon[4]=QPixmap(25,25);
  p->begin(&telos_caller_quality_icon[4]);
  p->setPen(QColor(green));
  p->setBrush(QColor(green));
  p->eraseRect(0,0,25,25);
  p->translate(12,12);
  p->drawPie(-5,-5,10,10,0,5760);
  p->end();

  telos_caller_quality_icon[5]=QPixmap(25,25);
  p->begin(&telos_caller_quality_icon[5]);
  p->setPen(QColor(green));
  p->setBrush(QColor(green));
  p->eraseRect(0,0,25,25);
  p->translate(12,12);
  p->drawPie(-5,-5,10,10,0,5760);
  p->moveTo(-5,-5);
  p->lineTo(-9,-9);
  p->moveTo(-5,5);
  p->lineTo(-9,9);
  p->moveTo(5,5);
  p->lineTo(9,9);
  p->moveTo(5,-5);
  p->lineTo(9,-9);
  p->moveTo(-7,0);
  p->lineTo(-12,0);
  p->moveTo(7,0);
  p->lineTo(12,0);
  p->moveTo(0,-7);
  p->lineTo(0,-12);
  p->moveTo(0,7);
  p->lineTo(0,12);
  p->end();
  delete p;


  //
  // Start Clock
  //
  if(ml_config->animateIcons()) {
    clock=new QTimer(this,"clock");
    connect(clock,SIGNAL(timeout()),this,SLOT(TickClock()));
    clock->start(FRAME_RATE);
  }
}



