//   mlhpisoundselector.h
//
//   A selection widget for audio devices.
//
//   (C) Copyright 2002-2007 Fred Gleason <fredg@paravelsystems.com>
//
//    $Id: mlhpisoundselector.h,v 1.3 2007/10/16 18:22:16 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#ifndef MLHPISOUNDSELECTOR_H
#define MLHPISOUNDSELECTOR_H

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <qobject.h>
#include <qwidget.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <qlistbox.h>

#include <mlhpisoundcard.h>

#ifdef HPI
#include <asihpi/hpi.h>
#endif  // HPI

#ifdef ALSA
#include <alsa/asoundlib.h>
#endif  // HPI

#ifdef JACK
#include <jack/jack.h>
#endif  // JACK

/**
 * @short A selector box for sound card resources.
 * @author Fred Gleason <fredg@wava.com>
 *
 * RSoundSelector implements a ListBox showing the available Input
 * or Output channels on a sound card.  It automatically displays all
 * such resources found by RSoundCard, and will emit signals to determine
 * the users selection of one.
 **/
class MLHPISoundSelector : public QListBox
{
  Q_OBJECT

  public:
  /**
   * Create a MLHPISoundSelector for either an Input or Output device class.
   * @param hpi_handle HPI subsystem handle.
   * @param dev_class The device class.
   * @param parent The parent widget.
   * @param name The name of the widget.
   **/
   MLHPISoundSelector(MLHPISoundCard::DeviceClass dev_class,
		  QWidget *parent=0,const char *name=0);

  signals:

  /**
   * Emitted whenever the selection is changed.
   * @param card The new card selection.
   * @param stream The new port selection.
   **/
   void changed(int card,int port);

  /**
   * Emitted whenever the selection is changed.
   * @param card The new card selection.
   **/
   void cardChanged(int card);

  /**
   * Emitted whenever the selection is changed.
   * @param stream The new stream selection.
   **/
   void portChanged(int port);

  private slots:
   void selection(int selection);

  private:
   MLHPISoundCard *sound_card;
};


#endif  // MLHPISOUNDSELECTOR_H
