// mlconfig.cpp
//
// A container class for CallCommander ml(1) Configuration
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rprofile.h>
#include <rconf.h>

#include <mlconfig.h>


MlConfig::MlConfig()
{
  ml_seglist=new RSegList();
  clear();
}


MlConfig::MlConfig(QString filename)
{
  ml_seglist=new RSegList();
  clear();
  ml_filename=filename;
}


QString MlConfig::filename() const
{
  return ml_filename;
}


void MlConfig::setFilename(QString filename)
{
  ml_filename=filename;
}


QString MlConfig::connectionName() const
{
  return ml_connection_name;
}


bool MlConfig::animateIcons() const
{
  return ml_animate_icons;
}


QRect MlConfig::window() const
{
  return ml_window;
}


bool MlConfig::keepOnTop() const
{
  return ml_keep_on_top;
}


bool MlConfig::disableNewButton() const
{
  return ml_disable_new_button;
}


bool MlConfig::disableEditButton() const
{
  return ml_disable_edit_button;
}


bool MlConfig::disableDeleteButton() const
{
  return ml_disable_delete_button;
}


bool MlConfig::disableOpenButton() const
{
  return ml_disable_open_button;
}


bool MlConfig::logEnable() const
{
  return ml_log_enable;
}


MlConfig::LogType MlConfig::logType() const
{
  return ml_log_type;
}


QString MlConfig::logShowCode() const
{
  return ml_log_showcode;
}


QString MlConfig::logFilename() const
{
  return ml_log_filename;
}


QString MlConfig::logFormat() const
{
  return ml_log_format;
}


QString MlConfig::logSqlServer() const
{
  return ml_log_sql_server;
}


QString MlConfig::logSqlDb() const
{
  return ml_log_sql_db;
}


QString MlConfig::logSqlUsername() const
{
  return ml_log_sql_username;
}


QString MlConfig::logSqlPassword() const
{
  return ml_log_sql_password;
}


bool MlConfig::disableLineButtons() const
{
  return ml_disable_line_buttons;
}


bool MlConfig::disableLineBoxes() const
{
  return ml_disable_line_boxes;
}


QString MlConfig::skimmerAudioRoot() const
{
  return ml_skimmer_audio_root;
}


int MlConfig::skimmerSampleRate() const
{
  return ml_skimmer_sample_rate;
}


int MlConfig::skimmerChannels() const
{
  return ml_skimmer_channels;
}


int MlConfig::skimmerBitrate() const
{
  return ml_skimmer_bitrate;
}


RWaveFile::Format MlConfig::skimmerFormat() const
{
  return ml_skimmer_format;
}


int MlConfig::skimmerCardNum(int bank) const
{
  return ml_skimmer_card[bank];
}


int MlConfig::skimmerPortNum(int bank) const
{
  return ml_skimmer_port[bank];
}


QString MlConfig::skimmerFilename(int bank) const
{
  return ml_skimmer_filename[bank];
}


QString MlConfig::skimmerPostCommand(int bank) const
{
  return ml_skimmer_post_command[bank];
}


int MlConfig::skimmerMaxLength(int bank) const
{
  return ml_skimmer_max_length[bank];
}


int MlConfig::skimmerInputLevel(int bank) const
{
  return ml_skimmer_level[bank];
}


MlConfig::AudioInputType MlConfig::skimmerInputType(int bank) const
{
  return ml_skimmer_input_type[bank];
}


bool MlConfig::skimmerEnable(int bank,int line) const
{
  return ml_skimmer_enable[bank][line];
}


void MlConfig::setSkimmerEnable(int bank,int line,bool state)
{
  ml_skimmer_enable[bank][line]=state;
}


QColor MlConfig::color(ColorRole role) const
{
  return ml_color[role];
}


QPalette MlConfig::palette(ColorRole role) const
{
  return ml_palette[role];
}


bool MlConfig::msgboxShow() const
{
  return ml_msgbox_show;
}


QRect MlConfig::msgboxWindow() const
{
  return ml_msgbox_window;
}


QString MlConfig::msgboxNickname() const
{
  return ml_msgbox_nickname;
}


int MlConfig::msgboxScrollbackLines() const
{
  return ml_msgbox_scrollback_lines;
}


int MlConfig::msgboxHangTime() const
{
  return ml_msgbox_hangtime;
}


QFont MlConfig::msgboxFont() const
{
  return ml_msgbox_font;
}


Qt::Orientation MlConfig::clockOrientation() const
{
  return ml_clock_orientation;
}


bool MlConfig::clockShowClock() const
{
  return ml_clock_show_clock;
}


int MlConfig::clockTimeOffset() const
{
  return ml_clock_time_offset;
}


QPoint MlConfig::clockPosition() const
{
  return ml_clock_position;
}


bool MlConfig::clockShowHour() const
{
  return ml_clock_show_hour;
}


bool MlConfig::clockMilitaryFormat() const
{
  return ml_clock_military_format;
}


RSegList *MlConfig::segmentList()
{
  return ml_seglist;
}


bool MlConfig::buttonShow(ButtonRole role) const
{
  return ml_button_show[role];
}


QPoint MlConfig::buttonPosition(ButtonRole role) const
{
  return ml_button_position[role];
}


QString MlConfig::buttonKey(ButtonRole role) const
{
  return ml_button_key[role];
}


bool MlConfig::bankShowHoldButton(int bank) const
{
  return ml_bank_show_hold_button[bank];
}


QPoint MlConfig::bankHoldPosition(int bank) const
{
  return ml_bank_hold_position[bank];
}


QString MlConfig::bankHoldKey(int bank) const
{
  return ml_bank_hold_key[bank];
}


bool MlConfig::bankShowDropButton(int bank) const
{
  return ml_bank_show_drop_button[bank];
}


QPoint MlConfig::bankDropPosition(int bank) const
{
  return ml_bank_drop_position[bank];
}


QString MlConfig::bankDropKey(int bank) const
{
  return ml_bank_drop_key[bank];
}


QSize MlConfig::callerSize() const
{
  return ml_caller_size;
}


bool MlConfig::callerShow(CallerFields field) const
{
  return ml_caller_show[field];
}


QRect MlConfig::callerWindow(CallerFields field) const
{
  return ml_caller_window[field];
}


QFont MlConfig::callerFont(CallerFields field) const
{
  return ml_caller_font[field];
}


bool MlConfig::lineShow(int bank,int line) const
{
  return ml_line_show[bank][line];
}


QPoint MlConfig::linePosition(int bank,int line) const
{
  return ml_line_position[bank][line];
}


QString MlConfig::lineKey(int bank,int line) const
{
  return ml_line_key[bank][line];
}


QString MlConfig::lineLabel(int bank) const
{
  return ml_line_label[bank];
}


int MlConfig::lineFontSize(int line) const
{
  return ml_line_font_size[line];
}


bool MlConfig::lineShowCallerBox(int line) const
{
  return ml_line_show_caller_box[line];
}


QRect MlConfig::lineCallerBoxWindow(int line) const
{
  return ml_line_caller_box_window[line];
}


QString MlConfig::lineCallerKey(int line) const
{
  return ml_line_caller_key[line];
}


bool MlConfig::disableWatchdog() const
{
  return ml_disable_watchdog;
}


bool MlConfig::disableStatusSync() const
{
  return ml_disable_status_sync;
}


bool MlConfig::disableCallerSync() const
{
  return ml_disable_caller_sync;
}


bool MlConfig::disableMessageSync() const
{
  return ml_disable_message_sync;
}


bool MlConfig::disableAutoDetect() const
{
  return ml_disable_auto_detect;
}


void MlConfig::dumpConfig(FILE *stream)
{
}


void MlConfig::load()
{
  int dy=0;
  QString str;
  QString face;
  QString weight;
  QString section;
  int size;
  QString filename=ml_filename;
  QString bankname;
  QString temp;

  clear();
  ml_filename=filename;
  
  //
  // Load the Parser
  //
  RProfile *parser=new RProfile();
  parser->setSource(ml_filename);

  //
  // [Global] Section
  //
  ml_connection_name=parser->stringValue("Global","ConnectionName");
  ml_animate_icons=
    parser->boolValue("Global","AnimateIcons",ml_animate_icons);
#ifdef WIN32
  dy=20;
#endif
  ml_ask_host=parser->boolValue("Global","AskHost",true);
  ml_window=QRect(parser->intValue("Global","WindowX",ml_window.x()),
		  parser->intValue("Global","WindowY",ml_window.y())+dy,
		  parser->intValue("Global","SizeX",ml_window.width()),
		  parser->intValue("Global","SizeY",ml_window.height()));
  ml_keep_on_top=parser->boolValue("Global","KeepOnTop",ml_keep_on_top);

  //
  // [ConnectionManager] Section
  //
  ml_disable_new_button=
    parser->boolValue("ConnectionManager","DisableNewButton",
		      ml_disable_new_button);
  ml_disable_edit_button=
    parser->boolValue("ConnectionManager","DisableEditButton",
		      ml_disable_edit_button);
  ml_disable_delete_button=
    parser->boolValue("ConnectionManager","DisableDeleteButton",
		      ml_disable_delete_button);
  ml_disable_open_button=
    parser->boolValue("ConnectionManager","DisableOpenButton",
		      ml_disable_open_button);

  //
  // [Debug] Section
  //
  ml_disable_watchdog=
    parser->boolValue("Debug","DisableWatchdog",ml_disable_watchdog);
  ml_disable_status_sync=
    parser->boolValue("Debug","DisableStatusSync",ml_disable_status_sync);
  ml_disable_caller_sync=
    parser->boolValue("Debug","DisableCallerSync",ml_disable_caller_sync);
  ml_disable_message_sync=
    parser->boolValue("Debug","DisableMessageSync",ml_disable_message_sync);
  ml_disable_auto_detect=
    parser->boolValue("Debug","DisableAutoDetect",ml_disable_auto_detect);

  //
  // [Controls] Section
  //
  ml_disable_line_buttons=
    parser->boolValue("Controls","DisableLineButtons",ml_disable_line_buttons);
  ml_disable_line_boxes=
    parser->boolValue("Controls","DisableLineBoxes",ml_disable_line_boxes);

  //
  // [Logging] Section
  //
  ml_log_enable=parser->boolValue("Logging","Enable",ml_log_enable);
  str=parser->stringValue("Logging","Type").lower();
  if(str=="sql") {
    ml_log_type=MlConfig::Sql;
  }
  ml_log_showcode=parser->stringValue("Logging","ShowCode",ml_log_showcode);

  //
  // Skimmer Section
  //
  for(int i=0;i<MAX_BANKS;i++) {
    if(i==0) {
      bankname="Main";
    }
    else {
      bankname="Conf";
    }
    ml_skimmer_card[i]=parser->
      intValue("Skimmer",bankname+"Card",ml_skimmer_card[i]);
    ml_skimmer_port[i]=parser->
      intValue("Skimmer",bankname+"Stream",i);
    ml_skimmer_port[i]=parser->
      intValue("Skimmer",bankname+"Port",ml_skimmer_port[i]);
    ml_skimmer_filename[i]=parser->
      stringValue("Skimmer",bankname+"Filename",ml_skimmer_filename[i]);
    ml_skimmer_post_command[i]=parser->
      stringValue("Skimmer",bankname+"PostCommand",ml_skimmer_post_command[i]);
    ml_skimmer_max_length[i]=
      RSetTimeLength(parser->stringValue("Skimmer",bankname+"MaxLength",
					 "00:00"));
    ml_skimmer_level[i]=parser->intValue("Skimmer",bankname+"Level",
					 ml_skimmer_level[i]);
    temp=parser->
      stringValue("Skimmer","MainInputType","digital");
    if(temp=="digital") {
      ml_skimmer_input_type[i]=MlConfig::AesEbu;
    }
    else {
      ml_skimmer_input_type[i]=MlConfig::Analog;
    }
    for(int j=0;j<MAX_LINES;j++) {
      temp=QString().sprintf("Enable%s%d",(const char *)bankname,j+1);
      ml_skimmer_enable[i][j]=parser->boolValue("Skimmer",temp,false);
    }
  }
  temp=parser->
    stringValue("Skimmer","AudioRoot",ml_skimmer_audio_root);
  if(temp.left(1)=="/") {
    ml_skimmer_audio_root=temp;
  }
  else {
    if(getenv("HOME")!=NULL) {
      ml_skimmer_audio_root=QString(getenv("HOME"))+QString("/")+temp;
    }
    else {
      ml_skimmer_audio_root=QString("/")+temp;
    }
  }
  if(ml_skimmer_audio_root.right(1)!="/") {
    ml_skimmer_audio_root+="/";
  }
  ml_skimmer_sample_rate=parser->intValue("Skimmer","SampleRate",
					  ml_skimmer_sample_rate);
  ml_skimmer_channels=parser->intValue("Skimmer","Channels",
				       ml_skimmer_channels);
  ml_skimmer_bitrate=parser->intValue("Skimmer","BitRate",
				      ml_skimmer_bitrate);
  temp=parser->stringValue("Skimmer","Format","pcm16");
  if(temp.lower()=="pcm16") {
    ml_skimmer_format=RWaveFile::Pcm16;
  }
  if(temp.lower()=="layer2") {
    ml_skimmer_format=RWaveFile::MpegL2;
  }
  if(temp.lower()=="layer3") {
    ml_skimmer_format=RWaveFile::MpegL3;
  }

  //
  // Disk [Logging] Entries
  //
  str=parser->stringValue("Logging","Filename",ml_log_filename);
  if(str.left(1)=="/") {
    ml_log_filename=str;
  }
  else {
    if(getenv("HOME")==NULL) {
      ml_log_filename="";
    }
    else {
      ml_log_filename=QString(getenv("HOME"));
    }
    ml_log_filename+=QString("/");
    ml_log_filename+=str;
  }
  ml_log_format=parser->stringValue("Logging","Format",ml_log_format);

  //
  // SQL [Logging] Entries
  //
  ml_log_sql_server=
    parser->stringValue("Logging","SqlServer",ml_log_sql_server);
  ml_log_sql_db=parser->stringValue("Logging","SqlDatabase",ml_log_sql_db);
  ml_log_sql_username=
    parser->stringValue("Logging","SqlUsername",ml_log_sql_username);
  ml_log_sql_password=
    parser->stringValue("Logging","SqlPassword",ml_log_sql_password);

  //
  // Colors Section
  //
  str=parser->stringValue("Colors","Idle","lightGray");
  ml_palette[MlConfig::IdleColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::IdleColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","InUse","darkGray");
  ml_palette[MlConfig::InUseColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::InUseColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","OnAir","red");
  ml_palette[MlConfig::OnAirColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::OnAirColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","OffHook","yellow");
  ml_palette[MlConfig::OffHookColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::OffHookColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","OnHold","green");
  ml_palette[MlConfig::OnHoldColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::OnHoldColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","ScreenedHold","green");
  ml_palette[MlConfig::ScreenedHoldColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::ScreenedHoldColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","ReadyNext","green");
  ml_palette[MlConfig::ReadyNextColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::ReadyNextColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","Ringing","blue");
  ml_palette[MlConfig::RingingColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::RingingColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","Busy","yellow");
  ml_palette[MlConfig::BusyColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::BusyColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","CallerBox","white");
  ml_palette[MlConfig::CallerBoxColor]=QColor(str);
  str=parser->stringValue("Colors","MessageBox","white");
  ml_palette[MlConfig::MessageBoxColor]=QColor(str);
  str=parser->stringValue("Colors","DumpButton","red");
  ml_palette[MlConfig::DumpButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::DumpButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","RecordButton","gray");
  ml_palette[MlConfig::RecordButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::RecordButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","NextButton","gray");
  ml_palette[MlConfig::NextButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::NextButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","KeypadButton","gray");
  ml_palette[MlConfig::KeypadButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::KeypadButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","ScreenButton","red");
  ml_palette[MlConfig::ScreenButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::ScreenButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","MuteButton","red");
  ml_palette[MlConfig::MuteButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::MuteButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","ConfButton","red");
  ml_palette[MlConfig::ConfButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::ConfButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","VipButton","red");
  ml_palette[MlConfig::VipButtonColor]=QPalette(QColor(str),QColor("black"));
  ml_palette[MlConfig::VipButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  str=parser->stringValue("Colors","ClientButton","red");
  ml_palette[MlConfig::ClientButtonColor]=QPalette(QColor(str),
						   QColor("black"));
  ml_palette[MlConfig::ClientButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));

  //
  // MessageBox Section
  //
  ml_msgbox_show=
    parser->boolValue("MessageBox","ShowMessageBox",ml_msgbox_show);
  ml_msgbox_window=
    QRect(parser->intValue("MessageBox","MessageBoxX",ml_msgbox_window.x()),
	  parser->intValue("MessageBox","MessageBoxY",ml_msgbox_window.y()),
	  parser->intValue("MessageBox","SizeX",ml_msgbox_window.width()),
	  parser->intValue("MessageBox","SizeY",ml_msgbox_window.height()));
  ml_msgbox_scrollback_lines=parser->intValue("MessageBox","ScrollBackLines",
					      ml_msgbox_scrollback_lines);
  str=parser->stringValue("MessageBox","Nickname","");
  if(str.isEmpty()) {
    if(getenv("USER")!=NULL) {
      ml_msgbox_nickname=QString(getenv("USER"));
    }
    else {
      ml_msgbox_nickname="user";
    }
  }
  else {
    ml_msgbox_nickname=str;
  }
  ml_msgbox_hangtime=
    parser->intValue("MessageBox","HangTime",ml_msgbox_hangtime);
  face=parser->stringValue("MessageBox","FontFace",ml_msgbox_font.family());
  size=parser->intValue("MessageBox","FontSize",12);
  weight=parser->stringValue("MessageBox","FontWeight",
			     SetFontWeight(ml_msgbox_font.weight()));
  ml_msgbox_font=QFont(face,size,RGetFontWeight(weight));
  ml_msgbox_font.setPixelSize(size);
  
  //
  // Clock Section
  //
  ml_clock_show_clock=
    parser->boolValue("Clock","ShowClock",ml_clock_show_clock);
  ml_clock_position=
    QPoint(parser->intValue("Clock","ClockX",ml_clock_position.x()),
	   parser->intValue("Clock","ClockY",ml_clock_position.y()));
  ml_clock_time_offset=
    parser->intValue("Clock","TimeOffset",ml_clock_time_offset);
  ml_clock_show_hour=parser->boolValue("Clock","ShowHour",ml_clock_show_hour);
  ml_clock_military_format=
    parser->boolValue("Clock","MilitaryFormat",ml_clock_military_format);
  str=parser->stringValue("Clock","Orientation");
  if(str.lower()=="horizontal") {
    ml_clock_orientation=Qt::Horizontal;
  }

  //
  // Busy Button Section
  //
  ml_button_show[MlConfig::BusyButton]=
    parser->boolValue("BusyButton","ShowButton",
		      ml_button_show[MlConfig::BusyButton]);
  ml_button_position[MlConfig::BusyButton]=
    QPoint(parser->intValue("BusyButton","ButtonX",
			    ml_button_position[MlConfig::BusyButton].x()),
	   parser->intValue("BusyButton","ButtonY",
			    ml_button_position[MlConfig::BusyButton].y()));
  ml_button_key[MlConfig::BusyButton]=
    parser->stringValue("BusyButton","Key",
			ml_button_key[MlConfig::BusyButton]);

  //
  // Dump Button Section
  //
  ml_button_show[MlConfig::DumpButton]=
    parser->boolValue("DumpButton","ShowButton",
		      ml_button_show[MlConfig::DumpButton]);
  ml_button_position[MlConfig::DumpButton]=
    QPoint(parser->intValue("DumpButton","ButtonX",
			    ml_button_position[MlConfig::DumpButton].x()),
	   parser->intValue("DumpButton","ButtonY",
			    ml_button_position[MlConfig::DumpButton].y()));
  ml_button_key[MlConfig::DumpButton]=
    parser->stringValue("DumpButton","Key",
			ml_button_key[MlConfig::DumpButton]);

  //
  // Record Button Section
  //
  ml_button_show[MlConfig::RecordButton]=
    parser->boolValue("RecordButton","ShowButton",
		      ml_button_show[MlConfig::RecordButton]);
  ml_button_position[MlConfig::RecordButton]=
    QPoint(parser->intValue("RecordButton","ButtonX",
			    ml_button_position[MlConfig::RecordButton].x()),
	   parser->intValue("RecordButton","ButtonY",
			    ml_button_position[MlConfig::RecordButton].y()));
  ml_button_key[MlConfig::RecordButton]=
    parser->stringValue("RecordButton","Key",
			ml_button_key[MlConfig::RecordButton]);

  //
  // Next Button Section
  //
  ml_button_show[MlConfig::NextButton]=
    parser->boolValue("NextButton","ShowButton",
		      ml_button_show[MlConfig::NextButton]);
  ml_button_position[MlConfig::NextButton]=
    QPoint(parser->intValue("NextButton","ButtonX",
			    ml_button_position[MlConfig::NextButton].x()),
	   parser->intValue("NextButton","ButtonY",
			    ml_button_position[MlConfig::NextButton].y()));
  ml_button_key[MlConfig::NextButton]=
    parser->stringValue("NextButton","Key",
			ml_button_key[MlConfig::NextButton]);

  //
  // Keypad Button Section
  //
  ml_button_show[MlConfig::KeypadButton]=
    parser->boolValue("KeypadButton","ShowButton",
		      ml_button_show[MlConfig::KeypadButton]);
  ml_button_position[MlConfig::KeypadButton]=
    QPoint(parser->intValue("KeypadButton","ButtonX",
			    ml_button_position[MlConfig::KeypadButton].x()),
	   parser->intValue("KeypadButton","ButtonY",
			    ml_button_position[MlConfig::KeypadButton].y()));
  ml_button_key[MlConfig::KeypadButton]=
    parser->stringValue("KeypadButton","Key",
			ml_button_key[MlConfig::KeypadButton]);

  //
  // Flash Button Section
  //
  ml_button_show[MlConfig::FlashButton]=
    parser->boolValue("FlashButton","ShowButton",
		      ml_button_show[MlConfig::FlashButton]);
  ml_button_position[MlConfig::FlashButton]=
    QPoint(parser->intValue("FlashButton","ButtonX",
			    ml_button_position[MlConfig::FlashButton].x()),
	   parser->intValue("FlashButton","ButtonY",
			    ml_button_position[MlConfig::FlashButton].y()));
  ml_button_key[MlConfig::FlashButton]=
    parser->stringValue("FlashButton","Key",
			ml_button_key[MlConfig::FlashButton]);

  //
  // Screen Button Section
  //
  ml_button_show[MlConfig::ScreenButton]=
    parser->boolValue("ScreenButton","ShowButton",
		      ml_button_show[MlConfig::ScreenButton]);
  ml_button_position[MlConfig::ScreenButton]=
    QPoint(parser->intValue("ScreenButton","ButtonX",
			    ml_button_position[MlConfig::ScreenButton].x()),
	   parser->intValue("ScreenButton","ButtonY",
			    ml_button_position[MlConfig::ScreenButton].y()));
  ml_button_key[MlConfig::ScreenButton]=
    parser->stringValue("ScreenButton","Key",
			ml_button_key[MlConfig::ScreenButton]);

  //
  // Mute Button Section
  //
  ml_button_show[MlConfig::MuteButton]=
    parser->boolValue("MuteButton","ShowButton",
		      ml_button_show[MlConfig::MuteButton]);
  ml_button_position[MlConfig::MuteButton]=
    QPoint(parser->intValue("MuteButton","ButtonX",
			    ml_button_position[MlConfig::MuteButton].x()),
	   parser->intValue("MuteButton","ButtonY",
			    ml_button_position[MlConfig::MuteButton].y()));
  ml_button_key[MlConfig::MuteButton]=
    parser->stringValue("MuteButton","Key",
			ml_button_key[MlConfig::MuteButton]);

  //
  // Conf Button Section
  //
  ml_button_show[MlConfig::ConfButton]=
    parser->boolValue("ConfButton","ShowButton",
		      ml_button_show[MlConfig::ConfButton]);
  ml_button_position[MlConfig::ConfButton]=
    QPoint(parser->intValue("ConfButton","ButtonX",
			    ml_button_position[MlConfig::ConfButton].x()),
	   parser->intValue("ConfButton","ButtonY",
			    ml_button_position[MlConfig::ConfButton].y()));
  ml_button_key[MlConfig::ConfButton]=
    parser->stringValue("ConfButton","Key",
			ml_button_key[MlConfig::ConfButton]);

  //
  // Vip Button Section
  //
  ml_button_show[MlConfig::VipButton]=
    parser->boolValue("VipButton","ShowButton",
		      ml_button_show[MlConfig::VipButton]);
  ml_button_position[MlConfig::VipButton]=
    QPoint(parser->intValue("VipButton","ButtonX",
			    ml_button_position[MlConfig::VipButton].x()),
	   parser->intValue("VipButton","ButtonY",
			    ml_button_position[MlConfig::VipButton].y()));
  ml_button_key[MlConfig::VipButton]=
    parser->stringValue("VipButton","Key",
			ml_button_key[MlConfig::VipButton]);

  //
  // Client Button Section
  //
  ml_button_show[MlConfig::ClientButton]=
    parser->boolValue("ClientButton","ShowButton",
		      ml_button_show[MlConfig::ClientButton]);
  ml_button_position[MlConfig::ClientButton]=
    QPoint(parser->intValue("ClientButton","ButtonX",
			    ml_button_position[MlConfig::ClientButton].x()),
	   parser->intValue("ClientButton","ButtonY",
			    ml_button_position[MlConfig::ClientButton].y()));
  ml_button_key[MlConfig::ClientButton]=
    parser->stringValue("ClientButton","Key",
			ml_button_key[MlConfig::ClientButton]);

  //
  // MainBank Section
  //
  ml_bank_show_hold_button[0]=
    parser->boolValue("MainBank","ShowHoldButton",ml_bank_show_hold_button[0]);
  ml_bank_hold_position[0]=
    QPoint(parser->intValue("MainBank","HoldButtonX",
			    ml_bank_hold_position[0].x()),
	   parser->intValue("MainBank","HoldButtonY",
			    ml_bank_hold_position[0].y()));
  ml_bank_hold_key[0]=
    parser->stringValue("MainBank","HoldKey",ml_bank_hold_key[0]);
  ml_bank_show_drop_button[0]=
    parser->boolValue("MainBank","ShowDropButton",ml_bank_show_drop_button[0]);
  ml_bank_drop_position[0]=
    QPoint(parser->intValue("MainBank","DropButtonX",
			    ml_bank_drop_position[0].x()),
	   parser->intValue("MainBank","DropButtonY",
			    ml_bank_drop_position[0].y()));
  ml_bank_drop_key[0]=
    parser->stringValue("MainBank","DropKey",ml_bank_drop_key[0]);

  //
  // ConfBank Section
  //
  ml_bank_show_hold_button[1]=
    parser->boolValue("ConfBank","ShowHoldButton",ml_bank_show_hold_button[1]);
  ml_bank_hold_position[1]=
    QPoint(parser->intValue("ConfBank","HoldButtonX",
			    ml_bank_hold_position[1].x()),
	   parser->intValue("ConfBank","HoldButtonY",
			    ml_bank_hold_position[1].y()));
  ml_bank_hold_key[1]=
    parser->stringValue("ConfBank","HoldKey",ml_bank_hold_key[1]);
  ml_bank_show_drop_button[1]=
    parser->boolValue("ConfBank","ShowDropButton",ml_bank_show_drop_button[1]);
  ml_bank_drop_position[1]=
    QPoint(parser->intValue("ConfBank","DropButtonX",
			    ml_bank_drop_position[1].x()),
	   parser->intValue("ConfBank","DropButtonY",
			    ml_bank_drop_position[1].y()));
  ml_bank_drop_key[1]=
    parser->stringValue("ConfBank","DropKey",ml_bank_drop_key[1]);

  //
  // Line Section
  //
  for(int i=0;i<MAX_LINES;i++) {
    section=QString().sprintf("Line%d",i+1);
    ml_line_show[0][i]=
      parser->boolValue(section,"ShowMainButton",ml_line_show[0][i]);
    ml_line_show[1][i]=
      parser->boolValue(section,"ShowConfButton",ml_line_show[1][i]);
    ml_line_show_caller_box[i]=
      parser->boolValue(section,"ShowCallerBox",ml_line_show_caller_box[i]);
    ml_line_position[0][i]=QPoint(parser->intValue(section,"MainButtonX",
				      ml_line_position[0][i].x()),
			parser->intValue(section,"MainButtonY",
				      ml_line_position[0][i].y()));
    ml_line_key[0][i]=parser->stringValue(section,"MainKey",ml_line_key[0][i]);
    ml_line_position[1][i]=QPoint(parser->intValue(section,"ConfButtonX",
				      ml_line_position[1][i].x()),
			parser->intValue(section,"ConfButtonY",
				      ml_line_position[1][i].y()));
    ml_line_key[1][i]=parser->stringValue(section,"ConfKey",ml_line_key[1][i]);

    ml_line_caller_box_window[i]=
      QRect(parser->intValue(section,"CallerBoxX",
			     ml_line_caller_box_window[i].x()),
	    parser->intValue(section,"CallerBoxY",
			     ml_line_caller_box_window[i].y()),
	    ml_caller_size.width(),ml_caller_size.height());
    ml_line_label[i]=parser->stringValue(section,"Label",ml_line_label[i]);
    ml_line_font_size[i]=
      parser->intValue(section,"FontSize",ml_line_font_size[i]);
    ml_line_caller_key[i]=
      parser->stringValue(section,"CallerKey",ml_line_caller_key[i]);
  }

  //
  // Segments Section
  //
  if(ml_clock_show_clock) {
    ml_seglist->setOffset(ml_clock_time_offset);
    ml_seglist->loadSegFile(ml_filename);
  }

  //
  // CallerBox Section
  //
  ml_caller_size=
    QSize(parser->intValue("CallerBox","SizeX",ml_caller_size.width()),
	  parser->intValue("CallerBox","SizeY",ml_caller_size.height()));

  //
  // Name
  //
  ml_caller_show[MlConfig::CallerName]=
    parser->boolValue("CallerBox","ShowName",
		      ml_caller_show[MlConfig::CallerName]);
  ml_caller_window[MlConfig::CallerName]=
    QRect(parser->intValue("CallerBox","NameX",
			   ml_caller_window[MlConfig::CallerName].x()),
	  parser->intValue("CallerBox","NameY",
			   ml_caller_window[MlConfig::CallerName].y()),
	  parser->intValue("CallerBox","NameSizeX",
			   ml_caller_window[MlConfig::CallerName].width()),
	  parser->intValue("CallerBox","NameSizeY",
			   ml_caller_window[MlConfig::CallerName].
			   height()));
  face=parser->stringValue("CallerBox","NameFontFace",
			   ml_caller_font[MlConfig::CallerName].family());
  size=parser->intValue("CallerBox","NameFontSize",18);
  weight=parser->stringValue("CallerBox","NameFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerName].weight()));
  ml_caller_font[MlConfig::CallerName]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerName].setPixelSize(size);
  
  //
  // Age
  //
  ml_caller_show[MlConfig::CallerAge]=
    parser->boolValue("CallerBox","ShowAge",
		      ml_caller_show[MlConfig::CallerAge]);
  ml_caller_window[MlConfig::CallerAge]=
    QRect(parser->intValue("CallerBox","AgeX",
			   ml_caller_window[MlConfig::CallerAge].x()),
	  parser->intValue("CallerBox","AgeY",
			   ml_caller_window[MlConfig::CallerAge].y()),
	  parser->intValue("CallerBox","AgeSizeX",
			   ml_caller_window[MlConfig::CallerAge].width()),
	  parser->intValue("CallerBox","AgeSizeY",
			   ml_caller_window[MlConfig::CallerAge].
			   height()));
  face=parser->stringValue("CallerBox","AgeFontFace",
			   ml_caller_font[MlConfig::CallerAge].family());
  size=parser->intValue("CallerBox","AgeFontSize",12);
  weight=parser->stringValue("CallerBox","AgeFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerAge].weight()));
  ml_caller_font[MlConfig::CallerAge]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerAge].setPixelSize(size);

  //
  // City-State
  //
  ml_caller_show[MlConfig::CallerCityState]=
    parser->boolValue("CallerBox","ShowCityState",
		      ml_caller_show[MlConfig::CallerCityState]);
  ml_caller_window[MlConfig::CallerCityState]=
    QRect(parser->intValue("CallerBox","CityStateX",
			   ml_caller_window[MlConfig::CallerCityState].x()),
	  parser->intValue("CallerBox","CityStateY",
			   ml_caller_window[MlConfig::CallerCityState].y()),
	  parser->intValue("CallerBox","CityStateSizeX",
			   ml_caller_window[MlConfig::CallerCityState].
			   width()),
	  parser->intValue("CallerBox","CityStateSizeY",
			   ml_caller_window[MlConfig::CallerCityState].
			   height()));
  face=parser->stringValue("CallerBox","CityStateFontFace",
			   ml_caller_font[MlConfig::CallerCityState].family());
  size=parser->intValue("CallerBox","CityStateFontSize",12);
  weight=parser->stringValue("CallerBox","CityStateFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerCityState].weight()));
  ml_caller_font[MlConfig::CallerCityState]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerCityState].setPixelSize(size);

  //
  // Zip Code
  //
  ml_caller_show[MlConfig::CallerZip]=
    parser->boolValue("CallerBox","ShowZip",
		      ml_caller_show[MlConfig::CallerZip]);
  ml_caller_window[MlConfig::CallerZip]=
    QRect(parser->intValue("CallerBox","ZipX",
			   ml_caller_window[MlConfig::CallerZip].x()),
	  parser->intValue("CallerBox","ZipY",
			   ml_caller_window[MlConfig::CallerZip].y()),
	  parser->intValue("CallerBox","ZipSizeX",
			   ml_caller_window[MlConfig::CallerZip].width()),
	  parser->intValue("CallerBox","ZipSizeY",
			   ml_caller_window[MlConfig::CallerZip].
			   height()));
  face=parser->stringValue("CallerBox","ZipFontFace",
			   ml_caller_font[MlConfig::CallerZip].family());
  size=parser->intValue("CallerBox","ZipFontSize",12);
  weight=parser->stringValue("CallerBox","ZipFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerZip].weight()));
  ml_caller_font[MlConfig::CallerZip]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerZip].setPixelSize(size);

  //
  // Phone
  //
  ml_caller_show[MlConfig::CallerPhone]=
    parser->boolValue("CallerBox","ShowPhone",
		      ml_caller_show[MlConfig::CallerPhone]);
  ml_caller_window[MlConfig::CallerPhone]=
    QRect(parser->intValue("CallerBox","PhoneX",
			   ml_caller_window[MlConfig::CallerPhone].x()),
	  parser->intValue("CallerBox","PhoneY",
			   ml_caller_window[MlConfig::CallerPhone].y()),
	  parser->intValue("CallerBox","PhoneSizeX",
			   ml_caller_window[MlConfig::CallerPhone].width()),
	  parser->intValue("CallerBox","PhoneSizeY",
			   ml_caller_window[MlConfig::CallerPhone].
			   height()));
  face=parser->stringValue("CallerBox","PhoneFontFace",
			   ml_caller_font[MlConfig::CallerPhone].family());
  size=parser->intValue("CallerBox","PhoneFontSize",12);
  weight=parser->stringValue("CallerBox","PhoneFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerPhone].weight()));
  ml_caller_font[MlConfig::CallerPhone]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerPhone].setPixelSize(size);

  //
  // Station
  //
  ml_caller_show[MlConfig::CallerStation]=
    parser->boolValue("CallerBox","ShowStation",
		      ml_caller_show[MlConfig::CallerStation]);
  ml_caller_window[MlConfig::CallerStation]=
    QRect(parser->intValue("CallerBox","StationX",
			   ml_caller_window[MlConfig::CallerStation].x()),
	  parser->intValue("CallerBox","StationY",
			   ml_caller_window[MlConfig::CallerStation].y()),
	  parser->intValue("CallerBox","StationSizeX",
			   ml_caller_window[MlConfig::CallerStation].width()),
	  parser->intValue("CallerBox","StationSizeY",
			   ml_caller_window[MlConfig::CallerStation].
			   height()));
  face=parser->stringValue("CallerBox","StationFontFace",
			   ml_caller_font[MlConfig::CallerStation].family());
  size=parser->intValue("CallerBox","StationFontSize",12);
  weight=parser->stringValue("CallerBox","StationFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerStation].weight()));
  ml_caller_font[MlConfig::CallerStation]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerStation].setPixelSize(size);

  //
  // Call Counter
  //
  ml_caller_show[MlConfig::CallerCallCounter]=
    parser->boolValue("CallerBox","ShowCallCounter",
		      ml_caller_show[MlConfig::CallerCallCounter]);
  ml_caller_window[MlConfig::CallerCallCounter]=
    QRect(parser->intValue("CallerBox","CallCounterX",
			   ml_caller_window[MlConfig::CallerCallCounter].x()),
	  parser->intValue("CallerBox","CallCounterY",
			   ml_caller_window[MlConfig::CallerCallCounter].y()),
	  parser->intValue("CallerBox","CallCounterSizeX",
			   ml_caller_window[MlConfig::CallerCallCounter].
			   width()),
	  parser->intValue("CallerBox","CallCounterSizeY",
			   ml_caller_window[MlConfig::CallerCallCounter].
			   height()));
  face=parser->stringValue("CallerBox","CallCounterFontFace",
			   ml_caller_font[MlConfig::CallerCallCounter].
			   family());
  size=parser->intValue("CallerBox","CallCounterFontSize",12);
  weight=parser->stringValue("CallerBox","CallCounterFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerCallCounter].
			 weight()));
  ml_caller_font[MlConfig::CallerCallCounter]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerCallCounter].setPixelSize(size);

  //
  // Gender
  //
  ml_caller_show[MlConfig::CallerGender]=
    parser->boolValue("CallerBox","ShowGender",
		      ml_caller_show[MlConfig::CallerGender]);
  ml_caller_window[MlConfig::CallerGender]=
    QRect(parser->intValue("CallerBox","GenderX",
			   ml_caller_window[MlConfig::CallerGender].x()),
	  parser->intValue("CallerBox","GenderY",
			   ml_caller_window[MlConfig::CallerGender].y()),
	  parser->intValue("CallerBox","GenderSizeX",
			   ml_caller_window[MlConfig::CallerGender].width()),
	  parser->intValue("CallerBox","GenderSizeY",
			   ml_caller_window[MlConfig::CallerGender].
			   height()));
  face=parser->stringValue("CallerBox","GenderFontFace",
			   ml_caller_font[MlConfig::CallerGender].family());
  size=parser->intValue("CallerBox","GenderFontSize",12);
  weight=parser->stringValue("CallerBox","GenderFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerGender].weight()));
  ml_caller_font[MlConfig::CallerGender]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerGender].setPixelSize(size);

  //
  // Comment
  //
  ml_caller_show[MlConfig::CallerComment]=
    parser->boolValue("CallerBox","ShowComment",
		      ml_caller_show[MlConfig::CallerComment]);
  ml_caller_window[MlConfig::CallerComment]=
    QRect(parser->intValue("CallerBox","CommentX",
			   ml_caller_window[MlConfig::CallerComment].x()),
	  parser->intValue("CallerBox","CommentY",
			   ml_caller_window[MlConfig::CallerComment].y()),
	  parser->intValue("CallerBox","CommentSizeX",
			   ml_caller_window[MlConfig::CallerComment].width()),
	  parser->intValue("CallerBox","CommentSizeY",
			   ml_caller_window[MlConfig::CallerComment].
			   height()));
  face=parser->stringValue("CallerBox","CommentFontFace",
			   ml_caller_font[MlConfig::CallerComment].family());
  size=parser->intValue("CallerBox","CommentFontSize",12);
  weight=parser->stringValue("CallerBox","CommentFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerComment].weight()));
  ml_caller_font[MlConfig::CallerComment]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerComment].setPixelSize(size);

  //
  // Cell Flag
  //
  ml_caller_show[MlConfig::CallerCell]=
    parser->boolValue("CallerBox","ShowCell",
		      ml_caller_show[MlConfig::CallerCell]);
  ml_caller_window[MlConfig::CallerCell]=
    QRect(parser->intValue("CallerBox","CellX",
			   ml_caller_window[MlConfig::CallerCell].x()),
	  parser->intValue("CallerBox","CellY",
			   ml_caller_window[MlConfig::CallerCell].y()),20,20);

  //
  // Quality Flag
  //
  ml_caller_show[MlConfig::CallerQuality]=
    parser->boolValue("CallerBox","ShowQuality",
		      ml_caller_show[MlConfig::CallerQuality]);
  ml_caller_window[MlConfig::CallerQuality]=
    QRect(parser->intValue("CallerBox","QualityX",
			   ml_caller_window[MlConfig::CallerQuality].x()),
	  parser->intValue("CallerBox","QualityY",
			   ml_caller_window[MlConfig::CallerQuality].y()),20,20);

  //
  // Caller Timer
  //
  ml_caller_show[MlConfig::CallerTimer]=
    parser->boolValue("CallerBox","ShowTimer",
		      ml_caller_show[MlConfig::CallerTimer]);
  ml_caller_window[MlConfig::CallerTimer]=
    QRect(parser->intValue("CallerBox","TimerX",
			   ml_caller_window[MlConfig::CallerTimer].x()),
	  parser->intValue("CallerBox","TimerY",
			   ml_caller_window[MlConfig::CallerTimer].y()),
	  parser->intValue("CallerBox","TimerSizeX",
			   ml_caller_window[MlConfig::CallerTimer].width()),
	  parser->intValue("CallerBox","TimerSizeY",
			   ml_caller_window[MlConfig::CallerTimer].
			   height()));
  face=parser->stringValue("CallerBox","TimerFontFace",
			   ml_caller_font[MlConfig::CallerTimer].family());
  size=parser->intValue("CallerBox","TimerFontSize",12);
  weight=parser->stringValue("CallerBox","TimerFontWeight",
	   SetFontWeight(ml_caller_font[MlConfig::CallerTimer].weight()));
  ml_caller_font[MlConfig::CallerTimer]=
    QFont(face,size,RGetFontWeight(weight));
  ml_caller_font[MlConfig::CallerTimer].setPixelSize(size);
  delete parser;
}


void MlConfig::clear()
{
  ml_connection_name="";
  ml_animate_icons=true;
  ml_ask_host=true;
  ml_window=QRect(0,0,1000,740);
  ml_keep_on_top=false;

  ml_disable_new_button=false;
  ml_disable_edit_button=false;
  ml_disable_delete_button=false;
  ml_disable_open_button=false;

  ml_log_enable=false;
  ml_log_type=MlConfig::Disk;
  ml_log_showcode="";
  ml_log_filename="ml%M%Y.log";
  ml_log_format="%m/%d/%Y,%k:%M:%S,\"%L\",\"%n\",\"%C\",\"%A\",\"%c\",\"%t\",\"%z\",\"%w\",\"%g\",\"%p\",\"%e\",\"%r\",\"%a\",\"%h\"";
  ml_log_sql_server="localhost";
  ml_log_sql_db="Commander";
  ml_log_sql_username="ccuser";
  ml_log_sql_password="letmein";

  ml_disable_line_buttons=false;
  ml_disable_line_boxes=false;

  ml_skimmer_audio_root="";
  ml_skimmer_sample_rate=48000;
  ml_skimmer_channels=2;
  ml_skimmer_bitrate=128000;
  ml_skimmer_bitrate=0;
  ml_skimmer_format=RWaveFile::Pcm16;
  ml_skimmer_card[0]=0;
  ml_skimmer_card[1]=0;
  ml_skimmer_port[0]=0;
  ml_skimmer_port[1]=1;
  ml_skimmer_filename[0]="main_bank_audio.wav";
  ml_skimmer_filename[1]="conf_bank_audio.wav";
  ml_skimmer_post_command[0]="";
  ml_skimmer_max_length[0]=0;
  ml_skimmer_max_length[1]=0;
  ml_skimmer_level[0]=400;
  ml_skimmer_level[1]=400;
  ml_skimmer_input_type[0]=MlConfig::Analog;
  ml_skimmer_input_type[1]=MlConfig::Analog;
  
  for(int i=0;i<MAX_BANKS;i++) {
    for(int j=0;j<MAX_LINES;j++) {
      ml_skimmer_enable[i][j]=false;
    }
  }
  ml_color[MlConfig::IdleColor]=QColor("lightGray");
  ml_palette[MlConfig::IdleColor]=
    QPalette(ml_color[MlConfig::IdleColor],QColor("black"));
  ml_palette[MlConfig::IdleColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::InUseColor]=QColor("yellow");
  ml_palette[MlConfig::InUseColor]=
    QPalette(ml_color[MlConfig::InUseColor],QColor("black"));
  ml_palette[MlConfig::InUseColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::OnAirColor]=QColor("red");
  ml_palette[MlConfig::OnAirColor]=
    QPalette(ml_color[MlConfig::OnAirColor],QColor("black"));
  ml_palette[MlConfig::OnAirColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::OffHookColor]=QColor("yellow");
  ml_palette[MlConfig::OffHookColor]=
    QPalette(ml_color[MlConfig::OffHookColor],QColor("black"));
  ml_palette[MlConfig::OffHookColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::OnHoldColor]=QColor("green");
  ml_palette[MlConfig::OnHoldColor]=
    QPalette(ml_color[MlConfig::OnHoldColor],QColor("black"));
  ml_palette[MlConfig::OnHoldColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::ScreenedHoldColor]=QColor("green");
  ml_palette[MlConfig::ScreenedHoldColor]=
    QPalette(ml_color[MlConfig::ScreenedHoldColor],QColor("black"));
  ml_palette[MlConfig::ScreenedHoldColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::ReadyNextColor]=QColor("green");
  ml_palette[MlConfig::ReadyNextColor]=
    QPalette(ml_color[MlConfig::ReadyNextColor],QColor("black"));
  ml_palette[MlConfig::ReadyNextColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::RingingColor]=QColor("blue");
  ml_palette[MlConfig::RingingColor]=
    QPalette(ml_color[MlConfig::RingingColor],QColor("black"));
  ml_palette[MlConfig::RingingColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::BusyColor]=QColor("yellow");
  ml_palette[MlConfig::BusyColor]=
    QPalette(ml_color[MlConfig::BusyColor],QColor("black"));
  ml_palette[MlConfig::BusyColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::CallerBoxColor]=QColor("white");
  ml_palette[MlConfig::CallerBoxColor]=ml_color[MlConfig::CallerBoxColor];
  ml_color[MlConfig::MessageBoxColor]=QColor("white");
  ml_palette[MlConfig::MessageBoxColor]=ml_color[MlConfig::MessageBoxColor];
  ml_color[MlConfig::DumpButtonColor]=QColor("red");
  ml_palette[MlConfig::DumpButtonColor]=
    QPalette(ml_color[MlConfig::DumpButtonColor],QColor("black"));
  ml_palette[MlConfig::DumpButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::RecordButtonColor]=QColor("gray");
  ml_palette[MlConfig::RecordButtonColor]=
    QPalette(ml_color[MlConfig::RecordButtonColor],QColor("black"));
  ml_palette[MlConfig::RecordButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::NextButtonColor]=QColor("gray");
  ml_palette[MlConfig::NextButtonColor]=
    QPalette(ml_color[MlConfig::NextButtonColor],QColor("black"));
  ml_palette[MlConfig::NextButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::KeypadButtonColor]=QColor("gray");
  ml_palette[MlConfig::KeypadButtonColor]=
    QPalette(ml_color[MlConfig::KeypadButtonColor],QColor("black"));
  ml_palette[MlConfig::KeypadButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::ScreenButtonColor]=QColor("red");
  ml_palette[MlConfig::ScreenButtonColor]=
    QPalette(ml_color[MlConfig::ScreenButtonColor],QColor("black"));
  ml_palette[MlConfig::ScreenButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::MuteButtonColor]=QColor("red");
  ml_palette[MlConfig::MuteButtonColor]=
    QPalette(ml_color[MlConfig::MuteButtonColor],QColor("black"));
  ml_palette[MlConfig::MuteButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::ConfButtonColor]=QColor("red");
  ml_palette[MlConfig::ConfButtonColor]=
    QPalette(ml_color[MlConfig::ConfButtonColor],QColor("black"));
  ml_palette[MlConfig::ConfButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_color[MlConfig::VipButtonColor]=QColor("red");
  ml_palette[MlConfig::VipButtonColor]=
    QPalette(ml_color[MlConfig::VipButtonColor],QColor("black"));
  ml_palette[MlConfig::VipButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  ml_palette[MlConfig::ClientButtonColor].
    setColor(QColorGroup::ButtonText,QColor("black"));
  
  ml_msgbox_show=true;
  ml_msgbox_window=QRect(175,525,300,165);
  ml_msgbox_nickname="";
  ml_msgbox_scrollback_lines=100;
  ml_msgbox_hangtime=5000;
  ml_msgbox_font=QFont("hevetica",16,QFont::Normal);
  ml_msgbox_font.setPixelSize(16);
  
  ml_clock_orientation=Qt::Vertical;
  ml_clock_show_clock=true;
  ml_clock_time_offset=0;
  ml_clock_position=QPoint(815,525);
  ml_clock_show_hour=true;
	   ml_clock_military_format=true;

  delete ml_seglist;
  ml_seglist=new RSegList();

  ml_button_show[MlConfig::BusyButton]=true;
  ml_button_position[MlConfig::BusyButton]=QPoint(5,525);
  ml_button_key[MlConfig::BusyButton]="Alt+B";
  ml_button_show[MlConfig::DumpButton]=true;
  ml_button_position[MlConfig::DumpButton]=QPoint(5,610);
  ml_button_key[MlConfig::DumpButton]="Alt+D";
  ml_button_show[MlConfig::RecordButton]=true;
  ml_button_position[MlConfig::RecordButton]=QPoint(90,525);
  ml_button_key[MlConfig::RecordButton]="Alt+R";
  ml_button_show[MlConfig::NextButton]=true;
  ml_button_position[MlConfig::NextButton]=QPoint(713,525);
  ml_button_key[MlConfig::NextButton]="Alt+N";
  ml_button_show[MlConfig::KeypadButton]=true;
  ml_button_position[MlConfig::KeypadButton]=QPoint(90,610);
  ml_button_key[MlConfig::KeypadButton]="Alt+K";
  ml_button_show[MlConfig::FlashButton]=false;
  ml_button_position[MlConfig::FlashButton]=QPoint(0,0);
  ml_button_key[MlConfig::FlashButton]="Alt+F";
  ml_button_show[MlConfig::ScreenButton]=false;
  ml_button_position[MlConfig::ScreenButton]=QPoint(0,0);
  ml_button_key[MlConfig::ScreenButton]="Alt+S";
  ml_button_show[MlConfig::MuteButton]=false;
  ml_button_position[MlConfig::MuteButton]=QPoint(0,0);
  ml_button_key[MlConfig::MuteButton]="Alt+M";
  ml_button_show[MlConfig::ConfButton]=false;
  ml_button_position[MlConfig::ConfButton]=QPoint(0,0);
  ml_button_key[MlConfig::ConfButton]="Alt+C";
  ml_button_show[MlConfig::VipButton]=false;
  ml_button_position[MlConfig::VipButton]=QPoint(0,0);
  ml_button_key[MlConfig::VipButton]="Alt+V";
  ml_button_show[MlConfig::ClientButton]=true;
  ml_button_position[MlConfig::ClientButton]=QPoint(713,610);
  ml_button_key[MlConfig::ClientButton]="Alt+W";

  ml_bank_show_hold_button[0]=true;
  ml_bank_show_hold_button[1]=true;
  ml_bank_hold_position[0]=QPoint(526,525);
  ml_bank_hold_position[1]=QPoint(611,525);
  ml_bank_hold_key[0]="Home";
  ml_bank_hold_key[1]="Shift+Home";
  ml_bank_show_drop_button[0]=true;
  ml_bank_show_drop_button[1]=true;
  ml_bank_drop_position[0]=QPoint(526,610);
  ml_bank_drop_position[1]=QPoint(611,610);
  ml_bank_drop_key[0]="End";
  ml_bank_drop_key[1]="Shift+End";

  ml_caller_size=QSize(300,80);
  ml_caller_show[MlConfig::CallerName]=true;
  ml_caller_window[MlConfig::CallerName]=QRect(5,5,190,19);
  ml_caller_font[MlConfig::CallerName]=QFont("helvetica",18,QFont::Bold);
  ml_caller_font[MlConfig::CallerName].setPixelSize(18);

  ml_caller_show[MlConfig::CallerAge]=false;
  ml_caller_window[MlConfig::CallerAge]=QRect(0,0,0,0);
  ml_caller_font[MlConfig::CallerAge]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerAge].setPixelSize(12);

  ml_caller_show[MlConfig::CallerCityState]=true;
  ml_caller_window[MlConfig::CallerCityState]=QRect(5,22,190,19);
  ml_caller_font[MlConfig::CallerCityState]=
    QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerAge].setPixelSize(12);

  ml_caller_show[MlConfig::CallerZip]=false;
  ml_caller_window[MlConfig::CallerZip]=QRect(0,0,0,0);
  ml_caller_font[MlConfig::CallerZip]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerZip].setPixelSize(12);

  ml_caller_show[MlConfig::CallerPhone]=false;
  ml_caller_window[MlConfig::CallerPhone]=QRect(0,0,0,0);
  ml_caller_font[MlConfig::CallerPhone]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerPhone].setPixelSize(12);

  ml_caller_show[MlConfig::CallerStation]=true;
  ml_caller_window[MlConfig::CallerStation]=QRect(200,22,60,19);
  ml_caller_font[MlConfig::CallerStation]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerStation].setPixelSize(12);

  ml_caller_show[MlConfig::CallerGender]=true;
  ml_caller_window[MlConfig::CallerGender]=QRect(265,22,20,19);
  ml_caller_font[MlConfig::CallerGender]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerGender].setPixelSize(12);

  ml_caller_show[MlConfig::CallerComment]=true;
  ml_caller_window[MlConfig::CallerComment]=QRect(5,45,290,33);
  ml_caller_font[MlConfig::CallerComment]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerComment].setPixelSize(12);

  ml_caller_show[MlConfig::CallerCallCounter]=false;
  ml_caller_window[MlConfig::CallerCallCounter]=QRect(0,0,0,0);
  ml_caller_font[MlConfig::CallerCallCounter]=
    QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerCallCounter].setPixelSize(12);

  ml_caller_show[MlConfig::CallerCell]=true;
  ml_caller_window[MlConfig::CallerCell]=QRect(200,1,20,20);

  ml_caller_show[MlConfig::CallerQuality]=true;
  ml_caller_window[MlConfig::CallerQuality]=QRect(170,1,20,20);

  ml_caller_show[MlConfig::CallerTimer]=true;
  ml_caller_window[MlConfig::CallerTimer]=QRect(240,19,20,20);
  ml_caller_font[MlConfig::CallerTimer]=QFont("helvetica",12,QFont::Normal);
  ml_caller_font[MlConfig::CallerTimer].setPixelSize(12);

  for(int i=0;i<MAX_BANKS;i++) {
    for(int j=0;j<MAX_LINES;j++) {
      ml_line_show[i][j]=true;
    }
  }
  ml_line_position[0][0]=QPoint(5,5);
  ml_line_position[1][0]=QPoint(90,5);

  ml_line_position[0][1]=QPoint(5,90);
  ml_line_position[1][1]=QPoint(90,90);

  ml_line_position[0][2]=QPoint(5,175);
  ml_line_position[1][2]=QPoint(90,175);

  ml_line_position[0][3]=QPoint(5,260);
  ml_line_position[1][3]=QPoint(90,260);

  ml_line_position[0][4]=QPoint(5,345);
  ml_line_position[1][4]=QPoint(90,345);

  ml_line_position[0][5]=QPoint(5,430);
  ml_line_position[1][5]=QPoint(90,430);

  ml_line_position[0][6]=QPoint(526,5);
  ml_line_position[1][6]=QPoint(611,5);

  ml_line_position[0][7]=QPoint(526,90);
  ml_line_position[1][7]=QPoint(611,90);

  ml_line_position[0][8]=QPoint(526,175);
  ml_line_position[1][8]=QPoint(611,175);

  ml_line_position[0][9]=QPoint(526,260);
  ml_line_position[1][9]=QPoint(611,260);

  ml_line_position[0][10]=QPoint(526,345);
  ml_line_position[1][10]=QPoint(611,345);

  ml_line_position[0][11]=QPoint(526,430);
  ml_line_position[1][11]=QPoint(611,430);

  ml_line_key[0][0]="F1";
  ml_line_key[0][1]="F2";
  ml_line_key[0][2]="F3";
  ml_line_key[0][3]="F4";
  ml_line_key[0][4]="F5";
  ml_line_key[0][5]="F6";
  ml_line_key[0][6]="F7";
  ml_line_key[0][7]="F8";
  ml_line_key[0][8]="F9";
  ml_line_key[0][9]="F10";
  ml_line_key[0][10]="F11";
  ml_line_key[0][11]="F12";
  ml_line_key[1][0]="Shift+F1";
  ml_line_key[1][1]="Shift+F2";
  ml_line_key[1][2]="Shift+F3";
  ml_line_key[1][3]="Shift+F4";
  ml_line_key[1][4]="Shift+F5";
  ml_line_key[1][5]="Shift+F6";
  ml_line_key[1][6]="Shift+F7";
  ml_line_key[1][7]="Shift+F8";
  ml_line_key[1][8]="Shift+F9";
  ml_line_key[1][9]="Shift+F10";
  ml_line_key[1][10]="Shift+F11";
  ml_line_key[1][11]="Shift+F12";
  ml_line_label[0]="1";
  ml_line_label[1]="2";
  ml_line_label[2]="3";
  ml_line_label[3]="4";
  ml_line_label[4]="5";
  ml_line_label[5]="6";
  ml_line_label[6]="7";
  ml_line_label[7]="8";
  ml_line_label[8]="9";
  ml_line_label[9]="10";
  ml_line_label[10]="11";
  ml_line_label[11]="12";
  ml_line_font_size[0]=36;
  ml_line_font_size[1]=36;
  ml_line_font_size[2]=36;
  ml_line_font_size[3]=36;
  ml_line_font_size[4]=36;
  ml_line_font_size[5]=36;
  ml_line_font_size[6]=36;
  ml_line_font_size[7]=36;
  ml_line_font_size[8]=36;
  ml_line_font_size[9]=36;
  ml_line_font_size[10]=36;
  ml_line_font_size[11]=36;
  ml_line_show_caller_box[0]=true;
  ml_line_show_caller_box[1]=true;
  ml_line_show_caller_box[2]=true;
  ml_line_show_caller_box[3]=true;
  ml_line_show_caller_box[4]=true;
  ml_line_show_caller_box[5]=true;
  ml_line_show_caller_box[6]=true;
  ml_line_show_caller_box[7]=true;
  ml_line_show_caller_box[8]=true;
  ml_line_show_caller_box[9]=true;
  ml_line_show_caller_box[10]=true;
  ml_line_show_caller_box[11]=true;
  ml_line_caller_box_window[0]=QRect(175,5,300,80);
  ml_line_caller_box_window[1]=QRect(175,90,300,80);
  ml_line_caller_box_window[2]=QRect(175,175,300,80);
  ml_line_caller_box_window[3]=QRect(175,260,300,80);
  ml_line_caller_box_window[4]=QRect(175,345,300,80);
  ml_line_caller_box_window[5]=QRect(175,430,300,80);
  ml_line_caller_box_window[6]=QRect(696,5,300,80);
  ml_line_caller_box_window[7]=QRect(696,90,300,80);
  ml_line_caller_box_window[8]=QRect(696,175,300,80);
  ml_line_caller_box_window[9]=QRect(696,260,300,80);
  ml_line_caller_box_window[10]=QRect(696,345,300,80);
  ml_line_caller_box_window[11]=QRect(696,430,300,80);
  ml_line_caller_key[0]="Ctrl+F1";
  ml_line_caller_key[1]="Ctrl+F2";
  ml_line_caller_key[2]="Ctrl+F3";
  ml_line_caller_key[3]="Ctrl+F4";
  ml_line_caller_key[4]="Ctrl+F5";
  ml_line_caller_key[5]="Ctrl+F6";
  ml_line_caller_key[6]="Ctrl+F7";
  ml_line_caller_key[7]="Ctrl+F8";
  ml_line_caller_key[8]="Ctrl+F9";
  ml_line_caller_key[9]="Ctrl+F10";
  ml_line_caller_key[10]="Ctrl+F11";
  ml_line_caller_key[11]="Ctrl+F12";

  ml_disable_watchdog=false;
  ml_disable_status_sync=false;
  ml_disable_caller_sync=false;
  ml_disable_message_sync=false;
  ml_disable_auto_detect=false;
}


QString MlConfig::SetFontWeight(int weight)
{
  switch((QFont::Weight)weight) {
      case QFont::Light:
	return "Light";

      case QFont::Normal:
	return "Normal";

      case QFont::DemiBold:
	return "DemiBold";

      case QFont::Bold:
	return "Bold";

      case QFont::Black:
	return "Black";
  }
  return "Unknown";
}
