// log_disk.cpp
//
// The disk-logger module for Call Commander
//
//   (C) Copyright 2002 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <mithlond.h>
#include <globals.h>


void MainWidget::LogDisk(int line)
{
  FILE *fd;

  fd=fopen((const char *)WildcardDecode(ml_config->logFilename()),"a+");
  fprintf(fd,"%s\n",(const char *)WildcardDecode(ml_config->logFormat(),line));
  fclose(fd);
}


QString MainWidget::WildcardDecode(QString spec,int line)
{
  QString string;

  for(unsigned i=0;i<spec.length();i++) {
    if(spec.at(i)!='%') {
      string+=spec.at(i);
    }
    else {
      i++;
      switch(((const char *)spec)[i]) {
	  case 'd':   // Day (01 - 31)
	    string+=QString().sprintf("%02d",QDate::currentDate().day());
	    break;

	  case 'm':   // Month (01 - 12)
	    string+=QString().sprintf("%02d",QDate::currentDate().month());
	    break;
	    
	  case 'Y':   // Year (yyyy)
	    string+=QString().sprintf("%04d",QDate::currentDate().year());
	    break;

	  case 'k':   // Hour (00 - 23)
	    string+=QString().sprintf("%02d",QTime::currentTime().hour());
	    break;

	  case 'M':   // Minute (00 - 59)
	    string+=QString().sprintf("%02d",QTime::currentTime().minute());
	    break;

	  case 'S':   // Second (00 - 60)
	    string+=QString().sprintf("%02d",QTime::currentTime().second());
	    break;

	  case 'i':   // Show Code
	    string+=QString().sprintf("%s",(const char *)ml_config->logShowCode());
	    break;

	  case 'L':   // Line Number
	    if(line>=0) {
	      string+=QString().sprintf("%d",line+1);
	    }
	    break;

	  case 'n':   // Caller Name
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::NameElement).toString();
	    }
	    break;

	  case 'C':   // Cellphone Flag
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::CellphoneElement).toString();
	    }
	    break;

	  case 'q':   // Quality Rating
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::QualityElement).toString();
	    }
	    break;

	  case 'A':   // Caller Age
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::AgeElement).toString();
	    }
	    break;

	  case 'c':   // Caller City
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::CityElement).toString();
	    }
	    break;

	  case 't':   // Caller State
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::StateElement).toString();
	    }
	    break;

	  case 'z':   // Caller ZIP Code
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::ZipElement).toString();
	    }
	    break;

	  case 'w':   // Caller Station
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::StationElement).toString();
	    }
	    break;

	  case 'g':   // Caller Gender
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::GenderElement).toString();
	    }
	    break;

	  case 'p':   // Caller Phone Number
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::PhoneElement).toString();
	    }
	    break;

	  case 'e':   // Caller Comment
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::CommentElement).toString();
	    }
	    break;

	  case 'r':   // Ring Timer
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::RingTimerElement).toString();
	    }
	    break;

	  case 'a':   // Air Timer
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::AirTimerElement).toString();
	    }
	    break;

	  case 'h':   // Hold Timer
	    if(line>=0) {
	      string+=telos_caller_data[line]->
		element(BusDriver::HoldTimerElement).toString();
	    }
	    break;
	  case '%':   // Literal '%'
	    string+=QString("%");
	    break;
      }
    }
  }
  return string;
}


