// message.h
//
// Message Password Widget for the Mithlond Project. 
//
//   (C) Copyright 2002 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef MESSAGE_H
#define MESSAGE_H

#include <qlineedit.h>
#include <qtextedit.h>
#include <qtimer.h>
#include <qpalette.h>

/*
 * Widget-wide defines
 */
#define SEND_BOX_HEIGHT 20


class Message : public QWidget
{
  Q_OBJECT
  public:
   Message(QColor base,unsigned hang_time=5000,
	   QWidget *parent=0,const char *name=0);
   QSize sizeHint() const;
   QSizePolicy sizePolicy() const;
   void setFont(const QFont &font);
   void setScrollback(int lines);
   void setMessage(QString msg);
   QString messageBuffer() const;
   void setMessageBuffer(QString buffer);
   int numLines() const;
   QString textLine(int) const;

  signals:
   void message(QString msg);
   void touched();

  public slots:
   void setGeometry(int x,int y,int w,int h);
   void setGeometry(const QRect &rect);
   void clickedData(int para,int pos);

  protected:
   void paintEvent(QPaintEvent *);

  private slots:
   void sendData();
   void timerData();

  private:
   void DrawBackdrop();
   QLineEdit *msg_send_box;
   QTextEdit *msg_rcv_box;
   QTimer *msg_hang_timer;
   QColor msg_base_color;
   unsigned msg_hang_time;
   bool msg_hanging;
   QPixmap *msg_backdrop;
   QBrush msg_backdrop_brush;
};


#endif

