// log_sql.cpp
//
// The sql-logger module for Call Commander
//
//   (C) Copyright 2002 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qsqldatabase.h>
//#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>

#include <mithlond.h>
#include <globals.h>


bool MainWidget::InitSql()
{
  //
  // Open Database
  //
  QSqlDatabase *db=QSqlDatabase::addDatabase("QMYSQL3");
  if(!db) {
    return false;
  }
  db->setDatabaseName(ml_config->logSqlDb());
  db->setUserName(ml_config->logSqlUsername());
  db->setPassword(ml_config->logSqlPassword());
  db->setHostName(ml_config->logSqlServer());
  if(!db->open()) {
    db->removeDatabase(ml_config->logSqlDb());
    return false;
  }
  return true;
}


void MainWidget::LogSql(int line)
{
  QSqlQuery *q;
  QString sql;
  QString cell_val;

  if(telos_caller_data[line]->
     element(BusDriver::CellphoneElement).toBool()) {
    cell_val="Y";
  }
  else {
    cell_val="N";
  }

  sql=QString().sprintf("insert into CALLS set PHONE=\"%s\",SHOWCODE=\"%s\",\
CALL_DATETIME=NOW(),NAME=\"%s\",AGE=%d,QUALITY=%d,CELLPHONE=\"%s\",\
CITY=\"%s\",STATE=\"%s\",ZIP=\"%s\",STATION=\"%s\",GENDER=\"%s\",\
COMMENT=\"%s\",RING_TIMER=%d,HOLD_TIMER=%d,AIR_TIMER=%d",
			(const char *)telos_caller_data[line]->
			element(BusDriver::PhoneElement).toString(),
			(const char *)ml_config->logShowCode(),
			(const char *)telos_caller_data[line]->
			element(BusDriver::NameElement).toString(),
			telos_caller_data[line]->
			element(BusDriver::AgeElement).toInt(),
			telos_caller_data[line]->
			element(BusDriver::QualityElement).toInt(),
			(const char *)cell_val,
			(const char *)telos_caller_data[line]->
			element(BusDriver::CityElement).toString(),
			(const char *)telos_caller_data[line]->
			element(BusDriver::StateElement).toString(),
			(const char *)telos_caller_data[line]->
			element(BusDriver::ZipElement).toString(),
			(const char *)telos_caller_data[line]->
			element(BusDriver::StationElement).toString(),
			(const char *)telos_caller_data[line]->
			element(BusDriver::GenderElement).toString(),
			(const char *)telos_caller_data[line]->
			element(BusDriver::CommentElement).toString(),
			telos_caller_data[line]->
			element(BusDriver::RingTimerElement).toInt(),
			telos_caller_data[line]->
			element(BusDriver::HoldTimerElement).toInt(),
			telos_caller_data[line]->
			element(BusDriver::AirTimerElement).toInt());
  q=new QSqlQuery(sql);
  delete q;
}
