// mithlond.h
//
// A Qt-based application for controlling broadcast telephone interfaces.
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//



#ifndef MITHLOND_H
#define MITHLOND_H

#include <qwidget.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qpushbutton.h>
#include <qcolor.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qrect.h>
#include <qpalette.h>
#include <qmainwindow.h>
#include <rsegclock.h>
#include <rseglist.h>
#include <rlabel.h>

#include <connection_data.h>
#include <call_meta_data.h>
#include <message_data.h>
#include <keybox.h>
#include <line_warning.h>
#include <mldconfig.h>

#include <telos2101_driver.h>
#include <telos100_driver.h>
#include <ts612_driver.h>
#include <virtual_driver.h>
#include <client_data.h>
#include <callers.h>
#include <message.h>
#include <list_clients.h>

/*
 * Global Values
 */
#define MAX_LINES 12
#define FRAME_RATE 100
#define MODE_CHANGE_POLL_RATE 5000
#define REQUEST_METADATA_DELAY 5000

QString GetConfFile(int argc,char *argv[]);

class MainWidget : public QMainWindow
{
  Q_OBJECT
 public:
  MainWidget(QWidget *parent=0,const char *name=0,WFlags f=0);
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;
  
 protected:
  void closeEvent(QCloseEvent *e);
  void paintEvent(QPaintEvent *);
  void moveEvent(QMoveEvent *e);

 private slots:
  void errorData(unsigned id,BusDriver::Error err);
  void lineButtonData(int id);
  void holdData(int bank);
  void dropData(int bank);
/*
  void mainHoldData();
  void mainDropData();
  void confHoldData();
  void confDropData();
*/
  void connectedData(unsigned id,bool state);
  void connectionClosedData(unsigned id);
  void currentShowData(unsigned id,const QString &show_name,bool state);
  void currentConsoleData(unsigned id,int console,ConsoleData::Mode mode);
  void TickClock();
  void busyData();
  void dumpPressedData();
  void dumpReleasedData();
  void recordData();
  void nextData();
  void keypadData();
  void flashData();
  void screenData();
  void muteData();
  void confData();
  void vipData();
  void clientData();
  void messageData(QString msg);
  void touchedData();
  void callerBoxData(int line);
  
  void lineStateData(unsigned id,BusDriver::LineState lstate,
		     unsigned line,int bank,int console);
  void busyAllStateData(unsigned id,bool state);
  void dumpDelayStateData(unsigned id,bool state);
  void recordStateData(unsigned id,bool state);
  void screenStateData(unsigned id,bool state);
  void muteStateData(unsigned id,bool state);
  void conferenceStateData(unsigned id,bool state);
  void vipStateData(unsigned id,bool state);
  void receivedStringData(unsigned id,BusDriver::Element elem,unsigned line,
			  const QString &str);
  void metadataUpdateRequestedData(unsigned id,ClientData::ClientType type);
  void requestMetadataData();

 private:
  enum LogType {Disk=1,Sql=2};
  void mouseDoubleClickEvent(QMouseEvent *e);
  void ProcessLineButton(int line);
  void LoadConfig();
  void DrawCaps();
  void UpdateTimer(int line,int value);
  void SendCallData(int line,bool=false);
  bool InitLogging();
  void LogCall(int);
  void LogDisk(int);
  bool InitSql();
  void LogSql(int);
  void ClearCallerBox(int);
  void UpdateCallerBox(int);
  void SetCaption();
  QString WildcardDecode(QString,int=-1);
  BusDriver *telos_driver;
  ConnectionData *telos_connection;
  ConsoleData::Mode telos_director_mode;
  QPushButton *telos_line[MAX_BANKS][12];
  BusDriver::LineState telos_status[MAX_LINES];
  int telos_bank[MAX_LINES];
  QPushButton *telos_hold_button[MAX_BANKS];
  QPushButton *telos_drop_button[MAX_BANKS];
  QString telos_config;
  QPixmap telos_cap[12][13][3];
  QPixmap telos_icon[13][3];
  QPixmap telos_hold_icon;
  QPixmap telos_drop_icon;
  int telos_icon_modulo[13];
  int telos_icon_frame[13];
  QTimer *clock;
  CallMetaData *telos_caller_data[MAX_LINES];
  CallMetaData *telos_caller_check_data;
  RLabel *telos_caller_name_label[MAX_LINES];
  RLabel *telos_caller_age_label[MAX_LINES];
  RLabel *telos_caller_citystate_label[MAX_LINES];
  RLabel *telos_caller_zip_label[MAX_LINES];
  RLabel *telos_caller_station_label[MAX_LINES];
  RLabel *telos_caller_gender_label[MAX_LINES];
  RLabel *telos_caller_phone_label[MAX_LINES];
  RLabel *telos_caller_comment_label[MAX_LINES];
  RLabel *telos_caller_callcounter_label[MAX_LINES];
  QPixmap telos_caller_cell_icon[2];
  QLabel *telos_caller_cell_label[MAX_LINES];
  QPixmap telos_caller_quality_icon[6];
  QLabel *telos_caller_quality_label[MAX_LINES];
  Message *telos_message_edit;
  MessageData *telos_message_data;
  QString telos_message_id;
  RSegClock *telos_clock_segclock;
  QPushButton *telos_busy_button;
  QPixmap telos_busy_icon;
  QPushButton *telos_dump_button;
  QPixmap telos_dump_icon;
  QPushButton *telos_record_button;
  QPixmap telos_record_icon[8];
  int telos_record_modulo;
  bool telos_record_running;
  int telos_record_frame;
  QPushButton *telos_next_button;
  QPixmap telos_next_icon;
  int telos_next_bank;
  QPushButton *telos_flash_button;
  bool telos_screen_state;
  QPushButton *telos_screen_button;
  bool telos_mute_state;
  QPushButton *telos_mute_button;
  bool telos_conf_state;
  QPushButton *telos_conf_button;
  bool telos_vip_state;
  QPushButton *telos_vip_button;
  QPixmap telos_keypad_icon;
  QPushButton *telos_keypad_button;
  Keybox *telos_keypad_dialog;
  Callers *telos_caller_dialog;
  LineWarning *telos_warning_box[MAX_LINES];
  QPixmap *telos_callcommander_map;
  QPushButton *telos_client_button;
  ListClients *telos_list_clients;
  QTimer *telos_metadata_timer;
  int telos_delay_offset;
};


#endif  // MITHLOND_H
