// msg_textedit.cpp
//
// A MessageBox Widget for CallCommander
//
//   (C) Copyright 2007 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <change_nickname.h>

#include <msg_textedit.h>


MsgTextEdit::MsgTextEdit(QWidget *parent,const char *name)
  : QTextEdit(parent,name)
{
}


void MsgTextEdit::setNickname(const QString &name)
{
  msg_nickname=name;
}


void MsgTextEdit::changeNicknameData()
{
  ChangeNickname *dialog=new ChangeNickname(&msg_nickname,this);
  if(dialog->exec()==0) {
    emit nicknameChanged(msg_nickname);
  }
  delete dialog;
}


QPopupMenu *MsgTextEdit::createPopupMenu(const QPoint &pos)
{
  msg_popup_menu=new QPopupMenu(this);
  msg_popup_menu->insertItem("&Change Screen Name",this,
			     SLOT(changeNicknameData()),8,-1);
  return msg_popup_menu;
}
