// rdsouond_panel.h
//
// The sound panel widget for RDAirPlay
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdsound_panel.h,v 1.19 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef RDSOUOND_PANEL_H
#define RDSOUOND_PANEL_H

#include <vector>

#include <qwidget.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <qsignalmapper.h>

#include <rpushbutton.h>
#include <rtransportbutton.h>

#include <rdcae.h>
#include <rdcart.h>
#include <rdstation.h>
#include <rduser.h>
#include <rdairplay_conf.h>
#include <rduser.h>
#include <rdpanel_button.h>
#include <rdbutton_dialog.h>
#include <rdbutton_panel.h>
#include <rdripc.h>
#include <rdevent_player.h>
#include <rdairplay_conf.h>


//
// Widget Settings
//
#define PANEL_BUTTON_COLUMNS 5
#define PANEL_BUTTON_ROWS 5
#define PANEL_BUTTON_SIZE_X 88
#define PANEL_BUTTON_SIZE_Y 80
#define PANEL_MAX_OUTPUTS 5


class RDSoundPanel : public QWidget
{
 Q_OBJECT
 public:
  RDSoundPanel(int station_panels,int use_panels,bool flash,
	       RDEventPlayer *player,RDRipc *ripc,RDCae *cae,
	       RDStation *station,QWidget *parent=0,const char *name=0);
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;
  int card(int outnum) const;
  void setCard(int outnum,int card);
  int port(int outnum) const;
  void setPort(int outnum,int port);
  QString outputText(int outnum) const;
  void setOutputText(int outnum,const QString &text);
  void setRmls(int outnum,const QString &start_rml,const QString &stop_rml);
  void setLogName(const QString &logname);
  void setSvcName(const QString &svcname);
  void setButton(RDAirPlayConf::PanelType type,int panel,int row,int col,
		 unsigned cartnum);
  void setLogfile(QString filename);
  void play(RDAirPlayConf::PanelType type,int panel,int row,int col,
	    RDLogLine::StartSource src);
  bool pause(RDAirPlayConf::PanelType type,int panel,int row,int col);
  void stop(RDAirPlayConf::PanelType type,int panel,int row,int col);
  RDAirPlayConf::ActionMode actionMode() const;
  void setActionMode(RDAirPlayConf::ActionMode mode);
  bool pauseEnabled() const;
  void setPauseEnabled(bool state);

 public slots:
  void changeUser();
  void tickClock();

 signals:
  void tick();
  void buttonFlash(bool state);
  void selectClicked(unsigned cartnum);

 private slots:
  void panelUp();
  void panelDown();
  void resetClickedData();
  void setupClickedData();
  void buttonMapperData(int id);
  void stateChangedData(int id,RDPlayDeck::State state);
  void positionData(int id,int pos);
  void timescalingSupportedData(int card,bool state);

 private:
  void PlayButton(RDAirPlayConf::PanelType type,int panel,int row,int col,
		  RDLogLine::StartSource src);
  bool PlayAudio(RDPanelButton *button,RDCart *cart);
  void PlayMacro(RDPanelButton *button,RDCart *cart);
  void PauseButton(RDAirPlayConf::PanelType type,int panel,int row,int col);
  void StopButton(RDAirPlayConf::PanelType type,int panel,int row,int col);
  void LoadPanels();
  void LoadPanel(RDAirPlayConf::PanelType type,int panel);
  void SaveButton(RDAirPlayConf::PanelType type,int panel,int row,int col);
  void SetPanelLabel();
  int PanelOffset(RDAirPlayConf::PanelType type,int panel);
  int GetFreeButtonDeck();
  int GetFreeOutput();
  void LogPlayEvent(unsigned cartnum,int cutnum);
  void LogTraffic(RDPanelButton *button);
  void LogTrafficMacro(RDPanelButton *button);
  void LogLine(QString str);
  void Playing(int id);
  void Paused(int id);
  void Stopped(int id);
  void ClearChannel(int id);
  void ClearReset();
  std::vector<RDButtonPanel> panel_buttons;
  RDCae *panel_cae;
  RDUser *panel_user;
  RTransportButton *panel_up_button;
  RTransportButton *panel_down_button;
  RPushButton *panel_setup_button;
  RPushButton *panel_reset_button;
  QLabel *panel_label;
  RDAirPlayConf::PanelType panel_type;
  RDButtonDialog *panel_button_dialog;
  QSignalMapper *panel_mapper;
  int panel_number;
  int panel_station_panels;
  int panel_user_panels;
  bool panel_setup_mode;
  bool panel_reset_mode;
  QWidget *panel_parent;
  RDRipc *panel_ripc;
  RDStation *panel_station;
  int panel_card[PANEL_MAX_OUTPUTS];
  int panel_port[PANEL_MAX_OUTPUTS];
  QString panel_output_text[PANEL_MAX_OUTPUTS];
  QString panel_start_rml[PANEL_MAX_OUTPUTS];
  QString panel_stop_rml[PANEL_MAX_OUTPUTS];
  RDPanelButton *panel_active_buttons[RD_MAX_STREAMS];
  bool panel_flash;
  int panel_flash_count;
  bool panel_flash_state;
  QString panel_logname;
  QString panel_logfile;
  bool panel_timescaling_supported[PANEL_MAX_OUTPUTS];
  bool panel_config_panels;
  RDEventPlayer *panel_event_player;
  QString panel_svcname;
  RDAirPlayConf::ActionMode panel_action_mode;
  bool panel_pause_enabled;
};

#endif
