// rdpanel.h
//
// A Dedicated Cart Wall Utility for Rivendell.
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdpanel.h,v 1.6 2007/02/14 21:57:04 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#ifndef RDPANEL_H
#define RDPANEL_H

#include <qwidget.h>
#include <qsqldatabase.h>
#include <qtimer.h>

#include <rplaymeter.h>

#include <rdcae.h>
#include <rdmacro.h>
#include <rdconfig.h>

//
// Settings
//
#define MASTER_TIMER_INTERVAL 100
#define METER_INTERVAL 50


class MainWidget : public QWidget
{
  Q_OBJECT
 public:
  MainWidget(QWidget *parent=0,const char *name=0);
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;

 private slots:
  void userData();
  void masterTimerData();
  void meterData();
  void rmlReceivedData(RDMacro *rml);

 protected:
  void closeEvent(QCloseEvent *e);

 private:
  void RunLocalMacros(RDMacro *rml);
  void SetCaption();
  RDConfig *panel_config;
  QSqlDatabase *panel_db;
  QTimer *panel_master_timer;
  RDCae *panel_cae;
  RPlayMeter *panel_meter[2];
};


#endif  // RDPANEL_H
