// rdconf.h
//
// The header file for the rconf package
//
//   (C) Copyright 1996-2004 Fred Gleason <fredg@paravelsystems.com>
//
//    $Id: rdconf.h,v 1.3 2008-03-28 20:00:05 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU Library General Public License 
//   version 2 as published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef RDCONF_H
#define RDCONF_H

#define MAX_RETRIES 10
#include <stdlib.h>
#include <stdio.h>

#include <qstring.h>
#include <qdatetime.h>
#include <qfont.h>
#include <qhostaddress.h>
#include <qsqldatabase.h>
#include <qvariant.h>
#include <qdatetime.h>


/* Function Prototypes */
int GetPrivateProfileBool(const char *,const char *,const char *,bool);
int GetPrivateProfileString(const char *,const char *,const char *,char *,
			    const char *,int);
int GetPrivateProfileInt(const char *,const char *,const char *,int);
int GetPrivateProfileHex(const char *,const char *,const char *,int);
double GetPrivateProfileDouble(const char *,const char *,const char *,double);
int GetIni(const char *,const char *,const char *,char *,int);
int GetIniLine(FILE *,char *);
void Prepend(char *,char *);
int IncrementIndex(char *,int);
void StripLevel(char *); 
bool GetLock(const char *);
void ClearLock(const char *);
QString RDGetPathPart(QString path);
QString RDGetBasePart(QString path);
QString RDGetShortDate(QDate);
/**
 * Returns the name of the weekday in english regardless of the locale
 * configured.
 * @param weekday Integer value for the weekday; 1 = "Mon", 2 = "Tue", 
 * ... 7 = "Sun".  If the value is out of range 1 is defaulted to.
 **/
QString RDGetShortDayNameEN(int weekday);
QFont::Weight RDGetFontWeight(QString);
bool RDDetach(const QString &coredir);
bool RDBool(QString);
QString RDYesNo(bool);
QHostAddress RDGetHostAddr();
QString RDGetDisplay(bool strip_point=false);
bool RDDoesRowExist(QString table,QString name,QString test,
		   QSqlDatabase *db=0);
bool RDDoesRowExist(QString table,QString name,unsigned test,
		   QSqlDatabase *db=0);
QVariant RDGetSqlValue(QString table,QString name,QString test,
		      QString param,QSqlDatabase *db=0,bool *valid=0);
QVariant RDGetSqlValue(QString table,QString name,unsigned test,
		      QString param,QSqlDatabase *db=0,bool *valid=0);
bool RDIsSqlNull(QString table,QString name,QString test,
		QString param,QSqlDatabase *db=0);
bool RDIsSqlNull(QString table,QString name,unsigned test,
		QString param,QSqlDatabase *db=0);
QString RDGetTimeLength(int mseconds,bool leadzero=false,bool tenths=true);
int RDSetTimeLength(QString string);
bool RDCopy(QString srcfile,QString destfile);
#ifndef WIN32
bool RDWritePid(QString dirname,QString filename,int owner=-1,int group=-1);
void RDDeletePid(QString dirname,QString filename);
bool RDCheckPid(QString dirname,QString filename);
pid_t RDGetPid(QString pidfile);
#endif  // WIN32
QString RDGetHomeDir(bool *found=0);
bool RDTimeSynced();
QString RDTruncateAfterWord(QString str,int word,bool add_dots=false);
QString RDHomeDir();
QString RDTempDir();
QString RDTimeZoneName(const QDateTime &datetime);

#endif   // RDCONF_H
